/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data;

import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpace;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.MemorySpacesDialog;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.MemorySpacesUIActivator;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.MemorySpacesViewer;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.Messages;
import com.nxp.s32ds.cle.runtime.memory.spaces.core.DeviceCoreMemorySpaceDescriptor;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.dsf.gdb.launching.GDBProcess;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.GDBBackend;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class MemorySpaceDelegate
implements IViewActionDelegate,
IActionDelegate2,
IDebugEventSetListener {
    private MemorySpacesViewer viewer;
    private IAction action;

    public void run(IAction action) {
        Shell activeShell = Display.getDefault().getActiveShell();
        List<DeviceCoreMemorySpaceDescriptor> memorySpaces = this.viewer.getMemoryUIBase().getMemorySpacesByContext();
        if (!memorySpaces.isEmpty()) {
            MemorySpacesDialog dialog = new MemorySpacesDialog(activeShell, Messages.MemorySpaceDelegate_selection_dialog_title, memorySpaces);
            if (dialog.open() != 0) {
                return;
            }
            MemorySpace memSpace = dialog.getMemorySpace();
            try {
                this.viewer.addTabForMemorySpace(memSpace, null);
            }
            catch (CoreException e) {
                MemorySpacesUIActivator.getInstance().log(e.getStatus());
            }
        } else {
            MessageDialog.openWarning((Shell)activeShell, (String)Messages.MemorySpaces_warning_dialog_title, (String)Messages.MemorySpaces_error_empty_not_supported_msg);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        List<DeviceCoreMemorySpaceDescriptor> memorySpaces = this.viewer.getMemoryUIBase().getMemorySpacesByContext();
        this.action.setEnabled(!memorySpaces.isEmpty());
    }

    public void init(IViewPart view) {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        if (view instanceof MemorySpacesViewer) {
            this.viewer = (MemorySpacesViewer)view;
            this.viewer.setAddMemorySpaceAction(this.action);
        }
    }

    public void init(IAction action) {
        this.action = action;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (events == null || events.length < 1 || this.action == null || this.viewer == null) {
            return;
        }
        Arrays.stream(events).forEach(event -> {
            switch (event.getKind()) {
                case 32: {
                    Object data;
                    Object source = event.getSource();
                    if (source instanceof GDBBackend && (data = event.getData()) != null && data instanceof GdbLaunch) {
                        this.viewer.launchInitialized((GdbLaunch)data);
                    }
                    this.action.setEnabled(false);
                    break;
                }
                case 8: {
                    GDBProcess process;
                    ILaunch launch;
                    Object source = event.getSource();
                    if (source instanceof GDBProcess && (launch = (process = (GDBProcess)source).getLaunch()) instanceof GdbLaunch) {
                        this.viewer.launchTerminated((GdbLaunch)launch);
                    }
                    this.action.setEnabled(false);
                    break;
                }
            }
        });
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }
}

