/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data;

import com.nxp.s32ds.cle.cdt.memory.spaces.dsf.S32DbgMemoryBlock;
import java.math.BigInteger;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.views.memory.renderings.HexIntegerRendering;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.jface.preference.IPreferenceStore;

public class MemorySpaceRendering
extends HexIntegerRendering {
    private static final int BYTES_1 = 1;
    private static final int BYTES_2 = 2;
    private static final int BYTES_4 = 4;
    private static final int BYTES_8 = 8;
    private final String PREFERENCES_STRING = "%s:%s";
    private final String HEX_VALUE = "0x%s";
    private final String RENDERING_LABEL = "%s <%s>";
    private int addressableSize = 1;
    private int bytesPerRow;

    public MemorySpaceRendering(String renderingId) {
        super(renderingId);
    }

    public int getAddressableSize() {
        return this.addressableSize;
    }

    public void init(IMemoryRenderingContainer container, IMemoryBlock block) {
        super.init(container, block);
        if (block instanceof S32DbgMemoryBlock) {
            S32DbgMemoryBlock s32debuggerBlock = (S32DbgMemoryBlock)block;
            this.addressableSize = s32debuggerBlock.getMemorySpace().getBytesPerAddress();
            this.bytesPerRow = s32debuggerBlock.getMemorySpace().getBytesPerRow();
            this.formatBySize(this.addressableSize, block.getModelIdentifier());
        }
    }

    private void formatBySize(int addressableSize, String model) {
        int columnSize;
        switch (addressableSize) {
            case 2: {
                columnSize = 2;
                break;
            }
            case 4: 
            case 8: {
                columnSize = 1;
                break;
            }
            default: {
                columnSize = 4;
            }
        }
        IPreferenceStore prefStore = DebugUITools.getPreferenceStore();
        String rowPreferenceId = String.format("%s:%s", "org.eclipse.debug.ui.memory.rowSize", model);
        String columnPreferenceId = String.format("%s:%s", "org.eclipse.debug.ui.memory.columnSize", model);
        if (prefStore.getString(rowPreferenceId).isEmpty()) {
            prefStore.setValue(rowPreferenceId, this.bytesPerRow);
        }
        if (prefStore.getString(columnPreferenceId).isEmpty()) {
            prefStore.setValue(columnPreferenceId, columnSize);
        }
    }

    protected void updateRenderingLabel(boolean showAddress) {
    }

    public String getLabel() {
        Object labelData = this.getControl().getData();
        if (labelData instanceof String) {
            BigInteger address = this.getSelectedAddress();
            String addressPrefix = "";
            addressPrefix = address != null ? String.format("0x%s", this.getSelectedAddress().toString(16).toUpperCase()) : String.format("0x%s", String.valueOf(this.getMemoryBlock().getStartAddress()));
            return String.format("%s <%s>", addressPrefix, labelData);
        }
        return super.getLabel();
    }
}

