/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.ui.memento;

import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpace;
import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpaces;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.MemorySpacesUIActivator;
import com.nxp.s32ds.ext.rcp.runtime.ui.memento.RcpMementos;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;

public class MemorySpaceContextMemento
extends RcpMementos<Collection<MemorySpace>> {
    private static final String MEMSPACE_CHILD = "memory_space_";
    private static final String MEMSPACE_ID = "id";
    private static final String MEMSPACE_DEVICE = "device";
    private static final String MEMSPACE_CORE = "core";
    private static final String MEMSPACE_NAME = "name";
    private static final String MEMSPACE_BASE_ADDRESS = "base_address";
    private static final String MEMSPACE_BYTES_PER_ADDRESS = "bytes_per_address";
    private static final String MEMSPACE_BYTES_PER_ROW = "bytes_per_row";

    public MemorySpaceContextMemento(String mementoId) {
        super("MemorySpaceContextMemento", mementoId);
    }

    protected void saveToMemento(IMemento memento, Collection<MemorySpace> memSpaces) {
        int number = 0;
        for (MemorySpace memSpace : memSpaces) {
            IMemento memSpaceChild = memento.createChild(MEMSPACE_CHILD + String.valueOf(number++));
            memSpaceChild.putString(MEMSPACE_ID, memSpace.getId());
            memSpaceChild.putString(MEMSPACE_DEVICE, memSpace.getDevice());
            memSpaceChild.putString(MEMSPACE_CORE, memSpace.getCore());
            memSpaceChild.putString(MEMSPACE_NAME, memSpace.getName());
            memSpaceChild.putString(MEMSPACE_BASE_ADDRESS, memSpace.getBaseAddress().toString(16));
            memSpaceChild.putInteger(MEMSPACE_BYTES_PER_ADDRESS, memSpace.getBytesPerAddress());
            memSpaceChild.putInteger(MEMSPACE_BYTES_PER_ROW, memSpace.getBytesPerRow());
        }
    }

    protected Collection<MemorySpace> restoreFromMemento(IMemento memento, Collection<MemorySpace> memSpaces) {
        IMemento[] memorySpaces = memento.getChildren();
        if (memorySpaces.length == 0) {
            return Collections.emptyList();
        }
        Arrays.stream(memorySpaces).forEach(child -> {
            BigInteger baseAddress = new BigInteger(child.getString(MEMSPACE_BASE_ADDRESS), 16);
            MemorySpace memSpace = MemorySpaces.createMemorySpace((String)child.getString(MEMSPACE_ID), (String)child.getString(MEMSPACE_NAME), (String)child.getString(MEMSPACE_DEVICE), (String)child.getString(MEMSPACE_CORE), (BigInteger)baseAddress, (int)child.getInteger(MEMSPACE_BYTES_PER_ADDRESS), (int)child.getInteger(MEMSPACE_BYTES_PER_ROW));
            memSpaces.add(memSpace);
        });
        return memSpaces;
    }

    protected IPreferenceStore getPreferenceStore() {
        return MemorySpacesUIActivator.getInstance().getPreferenceStore();
    }
}

