/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.checkers.core;

import com.nxp.s32ds.ext.cdt.checkers.core.CdtLaunchConfigurationAbstractChecker;
import com.nxp.s32ds.ext.cdt.core.checker.IResourceChecker;
import com.nxp.s32ds.ext.ide.validation.core.LaunchConfigurationMarker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;

public class CdtLaunchConfigurationChecker
extends CdtLaunchConfigurationAbstractChecker
implements IResourceChecker {
    private static final String CONFIGURATION_PROJECT_NAME_ATTR = "org.eclipse.cdt.launch.PROJECT_ATTR";
    public static final String ATTR_MAPPED_RESOURCE = "org.eclipse.debug.core.MAPPED_RESOURCE_PATHS";
    public static final String ATTR_PRG_NAME = "org.eclipse.cdt.launch.PROGRAM_NAME";
    private static final Map<String, String> LC_TO_WARNING = new HashMap<String, String>();

    static {
        LC_TO_WARNING.put("com.lauterbach.trace32.debug.internal.core.T32LaunchConfigurationDelegate", "missing specification of a launch type 'com.lauterbach.trace32.debug.internal.core.T32LaunchConfigurationDelegate' (missing plug-in)");
        LC_TO_WARNING.put("ilg.gnuarmeclipse.debug.gdbjtag.openocd.launchConfigurationType", "with the type 'ilg.gnuarmeclipse.debug.gdbjtag.openocd.launchConfigurationType' is not supported");
        LC_TO_WARNING.put("com.freescale.cdt.launch.cw.download", "with the type 'com.freescale.cdt.launch.cw.download' is not supported");
    }

    public IStatus check(IResource resource, IProgressMonitor monitor) {
        return this.checkLaunchConfigurationFiles(resource);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected IStatus check(List<IFile> listLaunchFiles, IProject project) {
        launchManager = DebugPlugin.getDefault().getLaunchManager();
        block2: for (IFile launchFile : listLaunchFiles) {
            if (!launchFile.exists()) continue;
            launchConfiguration = launchManager.getLaunchConfiguration(launchFile);
            try {
                isValid = true;
                if (!CdtLaunchConfigurationChecker.isValidProjectNameAttribute(launchConfiguration, project.getName())) {
                    isValid = false;
                }
                if (!CdtLaunchConfigurationChecker.isValidProjectMappedResources(launchConfiguration, project.getName())) {
                    isValid = false;
                }
                if (!isValid) {
                    if (LaunchConfigurationMarker.containsMarker((IResource)launchFile)) continue;
                    LaunchConfigurationMarker.createMarker((IResource)launchFile, (IProject)project, (String)project.getName());
                    continue;
                }
                LaunchConfigurationMarker.delete((IResource)launchFile);
                continue;
            }
            catch (CoreException e) {
                ** for (textPair : CdtLaunchConfigurationChecker.LC_TO_WARNING.entrySet())
            }
lbl-1000:
            // 1 sources

            {
                if (!e.getMessage().contains(textPair.getKey())) continue;
                LaunchConfigurationMarker.delete((IResource)launchFile);
                LaunchConfigurationMarker.createMarkerProblem((IResource)launchFile, (IProject)project, (String)textPair.getValue());
lbl26:
                // 2 sources

            }
        }
        return Status.OK_STATUS;
    }

    private static boolean isValidProjectNameAttribute(ILaunchConfiguration launchConfiguration, String validValue) throws CoreException {
        boolean result = true;
        String projectNameAttribute = launchConfiguration.getAttribute(CONFIGURATION_PROJECT_NAME_ATTR, "");
        if (!projectNameAttribute.isEmpty()) {
            result = validValue.equals(projectNameAttribute);
        }
        return result;
    }

    private static boolean isValidProjectMappedResources(ILaunchConfiguration launchConfiguration, String validValue) throws CoreException {
        boolean result = true;
        List listMapedResources = launchConfiguration.getAttribute(ATTR_MAPPED_RESOURCE, new ArrayList());
        if (!listMapedResources.isEmpty()) {
            Optional<String> optResult = listMapedResources.stream().filter(e -> e.endsWith(validValue)).findAny();
            result = optResult.isPresent();
        }
        return result;
    }
}

