/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.examples.internal.core;

import com.nxp.s32ds.ext.ide.examples.internal.core.ExampleCoreActivator;
import com.nxp.s32ds.ext.ide.examples.internal.core.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public class ExampleProjectLoaderUtils {
    private static final String COMPONENT_PREFS_PATH = "/.settings/com.nxp.s32ds.cle.runtime.component.prefs";

    private ExampleProjectLoaderUtils() {
    }

    public static IProjectDescription getProjectDescriptorByPath(IPath path) {
        IProjectDescription pd = null;
        if (path == null || !path.toFile().exists()) {
            ExampleCoreActivator.getInstance().logError(Messages.ExampleProjectLoaderUtils_could_not_load_project_by_not_existing_path);
            return null;
        }
        try {
            pd = ResourcesPlugin.getWorkspace().loadProjectDescription(path);
        }
        catch (CoreException e) {
            ExampleCoreActivator.getInstance().log(e.getStatus());
        }
        if (pd == null) {
            ExampleCoreActivator.getInstance().logError(NLS.bind((String)Messages.ExampleProjectLoaderUtils_could_not_load_project, (Object)path.toString()));
        }
        return pd;
    }

    public static String getExamplePropertyByPath(IPath path, String propertyId) {
        String propertyValue = "";
        if (path == null || !path.toFile().exists()) {
            ExampleCoreActivator.getInstance().logError(Messages.ExampleProjectLoaderUtils_could_not_load_project_by_not_existing_path);
            return propertyValue;
        }
        String componentPrefsPath = path.toOSString().concat(File.separator).concat(COMPONENT_PREFS_PATH);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream fis = new FileInputStream(componentPrefsPath);){
                Properties props = new Properties();
                props.load(fis);
                propertyValue = props.getProperty(propertyId);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            ExampleCoreActivator.getInstance().logError(NLS.bind((String)Messages.ExampleProjectLoaderUtils_unable_extract_device_id, (Object)path.toString()), e);
        }
        return propertyValue;
    }
}

