/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.core;

import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ProjectUtils {
    public static final String ID_C_MANAGE = "com.crt.advproject.link.manage";
    public static final String ID_CPP_MANAGE = "com.crt.advproject.link.cpp.manage";
    protected static final Logger LOGGER = LogManager.getLogger(ProjectUtils.class);

    public static boolean isCDTProject(IProject project) {
        ICProjectDescriptionManager mgr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mgr.getProjectDescription(project, true);
        return des != null;
    }

    public static boolean isCppProject(IProject project) {
        boolean cppNature = false;
        try {
            cppNature = project.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return cppNature;
    }

    public static boolean isExecutableProject(IProject project) {
        return ProjectUtils.isProjectType(project, "org.eclipse.cdt.build.core.buildArtefactType.exe");
    }

    public static boolean isLibraryProject(IProject project) {
        return ProjectUtils.isProjectType(project, "org.eclipse.cdt.build.core.buildArtefactType.staticLib");
    }

    public static boolean isManagedLinkerScriptProject(IProject project) {
        IManagedProject managedProject;
        boolean isManagedLinkerScript = true;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project, (boolean)true);
        if (info != null && (managedProject = info.getManagedProject()) != null) {
            IConfiguration[] configs;
            boolean isCpp = ProjectUtils.isCppProject(project);
            IConfiguration[] iConfigurationArray = configs = managedProject.getConfigurations();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration config = iConfigurationArray[n2];
                if (config != null) {
                    isManagedLinkerScript &= ProjectUtils.isManaged(isCpp, config.getTargetTool());
                }
                ++n2;
            }
        }
        return isManagedLinkerScript;
    }

    private static boolean isManaged(boolean isCppProject, ITool targetTool) {
        IOption manageOpt;
        boolean managed = false;
        String id = ID_C_MANAGE;
        if (isCppProject) {
            id = ID_CPP_MANAGE;
        }
        if ((manageOpt = targetTool.getOptionBySuperClassId(id)) != null) {
            try {
                managed = manageOpt.getBooleanValue();
            }
            catch (BuildException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return managed;
    }

    public static boolean isMakeProject(IProject project) {
        IConfiguration cfg;
        IManagedBuildInfo info;
        boolean isMakeProject = false;
        if (project != null && (info = ManagedBuildManager.getBuildInfo((IResource)project, (boolean)false)) != null && (cfg = info.getDefaultConfiguration()) != null) {
            isMakeProject = !cfg.getBuilder().isManagedBuildOn();
        }
        return isMakeProject;
    }

    private static boolean isProjectType(IProject project, String type) {
        IManagedProject managedProject;
        boolean isType = false;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project, (boolean)true);
        if (info != null && (managedProject = info.getManagedProject()) != null) {
            IProjectType projectType = managedProject.getProjectType();
            IBuildPropertyValue property = null;
            if (projectType != null) {
                property = projectType.getBuildArtefactType();
                if (property != null) {
                    String artifactName = property.getId();
                    if (type != null) {
                        isType = type.equals(artifactName);
                    }
                }
            } else if (type == null) {
                isType = true;
            }
        }
        return isType;
    }

    public static String getStringByRegx(String text, String rexp) {
        Pattern p = Pattern.compile(rexp, 2);
        Matcher m = p.matcher(text);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static String join(String element1, String element2) {
        if (UtilsText.isEmpty((String)element2)) {
            return element1;
        }
        return String.join((CharSequence)"_", element1, element2);
    }
}

