/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.example.internal.core;

import com.nxp.s32ds.cle.ide.example.internal.core.ExampleRegistryActivator;
import com.nxp.s32ds.cle.ide.example.internal.core.Messages;
import com.nxp.s32ds.cle.runtime.example.registry.ExampleDescriptor;
import com.nxp.s32ds.cle.runtime.example.registry.ExampleRegistry;
import com.nxp.s32ds.ext.ide.examples.core.ExampleComponentProvider;
import com.nxp.s32ds.ext.ide.examples.core.IExampleComponent;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class ExampleProjectLoader {
    public static final String PROJECT_FILE = ".project";

    private static List<File> findProjectFiles(File fromFile) {
        ArrayList<File> listProjectFiles = new ArrayList<File>();
        if (fromFile != null && fromFile.exists()) {
            if (fromFile.isFile() && fromFile.getName().equals(PROJECT_FILE)) {
                listProjectFiles.add(fromFile);
                return listProjectFiles;
            }
            if (fromFile.isDirectory()) {
                File[] fileArray = fromFile.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File sfile = fileArray[n2];
                    listProjectFiles.addAll(ExampleProjectLoader.findProjectFiles(sfile));
                    ++n2;
                }
            }
        }
        return listProjectFiles;
    }

    private static List<IExampleComponent> loadModelObject(List<File> listProjectFiles, File contentFolder) {
        ArrayList<IExampleComponent> listProjects = new ArrayList<IExampleComponent>();
        for (File file : listProjectFiles) {
            Path relativePath = contentFolder.toPath().relativize(file.toPath());
            ArrayList<String> grouplist = new ArrayList<String>();
            int lastIndexPath = relativePath.getNameCount() - 2;
            int i = 0;
            while (i < lastIndexPath) {
                String strSegmentPath = relativePath.getName(i).toString();
                grouplist.add(strSegmentPath);
                ++i;
            }
            String group = String.join((CharSequence)";", grouplist);
            IExampleComponent exmComponent = ExampleComponentProvider.getModelObject((File)file, (String)group);
            if (exmComponent == null) continue;
            listProjects.add(exmComponent);
        }
        return listProjects;
    }

    public static Map<String, Map<String, List<IExampleComponent>>> loadFromExtension(Map<String, Map<String, List<IExampleComponent>>> categoryToComponents, ExampleRegistry exampleRegistry, IProgressMonitor progressMonitor) {
        List<String> categoryIds = exampleRegistry.getExampleCategoryDescriptors().stream().map(EntityDescriptor::getId).collect(Collectors.toList());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)exampleRegistry.getExampleDescriptors().size());
        for (ExampleDescriptor iter : exampleRegistry.getExampleDescriptors()) {
            String categoryId;
            File contentFolder;
            try {
                contentFolder = new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(iter.getPath(), true));
            }
            catch (CoreException e) {
                ExampleRegistryActivator.getInstance().log(e.getStatus());
                continue;
            }
            List<File> listProjectFiles = ExampleProjectLoader.findProjectFiles(contentFolder);
            List<IExampleComponent> listProjects = ExampleProjectLoader.loadModelObject(listProjectFiles, contentFolder);
            Collections.sort(listProjects, (c1, c2) -> {
                if (c1.getProjectName() != null && c2.getProjectName() != null) {
                    return c1.getProjectName().toLowerCase().compareTo(c2.getProjectName().toLowerCase());
                }
                if (c1.getProjectName() == null) {
                    return -1;
                }
                return 1;
            });
            String string = categoryId = iter.getCategoryId() != null ? iter.getCategoryId() : "";
            if (ExampleProjectLoader.isUndefinedCategory(categoryId, categoryIds)) {
                ExampleRegistryActivator.getInstance().logWarning(NLS.bind((String)Messages.ExampleProjectLoader_exampleHasUndefinedCategory, (Object)iter.getId(), (Object)iter.getCategoryId()));
                categoryId = "";
            }
            String componentName = iter.getName();
            categoryToComponents.compute(categoryId, (key, value) -> {
                Map map = value = value != null ? value : new HashMap();
                if (value.containsKey(componentName)) {
                    listProjects.addAll((Collection)value.get(componentName));
                }
                value.put(componentName, listProjects);
                return value;
            });
            subMonitor.worked(1);
        }
        return categoryToComponents;
    }

    private static boolean isUndefinedCategory(String categoryId, List<String> categoryIds) {
        return !categoryId.isEmpty() && !categoryIds.contains(categoryId);
    }
}

