/*  Copyright 2020-2022 NXP */
/* License: BSD 3-clause
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the
       names of its contributors may be used to endorse or promote products
       derived from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
 */

#if defined (ARMCM7)
  #include "ARMCM7.h"
#elif defined (ARMCM7_SP)
  #include "ARMCM7_SP.h"
#elif defined (ARMCM7_DP)
  #include "ARMCM7_DP.h"
#else
  #error device not specified!
#endif

#if defined (__ghs__)
typedef struct {
  uint64_t* dest;
  uint64_t  wlen;
} __ecc_table_t;

typedef struct {
  uint32_t* dest;
  uint32_t  wlen;
} __zero_table_t;

typedef struct {
  uint32_t const* src;
  uint32_t* dest;
  uint32_t  wlen;
} __copy_table_t;

extern char __ghsbegin_bss[], __ghssize_bss[];
extern char __ghsbegin_heap[], __ghssize_heap[];
extern char __ghsbegin_stack[], __ghssize_stack[];
extern char __etext[], __ghsbegin_data[], __ghssize_data[];
#if defined (__ITCM_PRESENT) && (__ITCM_PRESENT == 1U) && (__ITCM_INIT)
extern char __itcm_begin[], __itcm_size[];
#endif
#if defined (__DTCM_PRESENT) && (__DTCM_PRESENT == 1U) && (__DTCM_INIT)
extern char __dtcm_begin[], __dtcm_size[];
#endif

#pragma ghs section rodata =".ecc_tables"

const __ecc_table_t ecc_tables[] =
{
#ifdef START_FROM_FLASH
    {
      (uint64_t*)__ghsbegin_data,
      (uint64_t)__ghssize_data
    },
#endif
    {
      (uint64_t*)__ghsbegin_bss,
      (uint64_t)__ghssize_bss
    },
    {
      (uint64_t*)__ghsbegin_heap,
      (uint64_t)__ghssize_heap
    },
    {
      (uint64_t*)__ghsbegin_stack,
      (uint64_t)__ghssize_stack
#if defined (__ITCM_PRESENT) && (__ITCM_PRESENT == 1U) && (__ITCM_INIT)
    },
    {
      (uint64_t*)__itcm_begin,
      (uint64_t)__itcm_size
#endif
#if defined (__DTCM_PRESENT) && (__DTCM_PRESENT == 1U) && (__DTCM_INIT)
    },
    {
      (uint64_t*)__dtcm_begin,
      (uint64_t)__dtcm_size
#endif
    }
};

#pragma ghs section rodata =".zero_tables"
const __zero_table_t zero_tables[] =
  {
    {
      (uint32_t*)__ghsbegin_bss,
      (uint32_t)__ghssize_bss
    }
};


#pragma ghs section rodata =".copy_tables"
const __copy_table_t copy_tables[] =
  {
    {
      (uint32_t const*)__etext,
      (uint32_t*)__ghsbegin_data,
      (uint32_t)__ghssize_data
    }
};

#pragma ghs section rodata =default
#endif
