; Copyright 2020-2022 NXP

; SPDX-License-Identifier: Apache-2.0

; Licensed under the Apache License, Version 2.0 (the License); you may
; not use this file except in compliance with the License.
; You may obtain a copy of the License at

; www.apache.org/licenses/LICENSE-2.0

; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an AS IS BASIS, WITHOUT
; WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.


        EXTERN  .data_init$$Base
        EXTERN  DATA$$Base
        EXTERN  DATA$$Length
        EXTERN  .bss$$Base
        EXTERN  .bss$$Length
        EXTERN  CSTACK$$Base
        EXTERN  CSTACK$$Length
        EXTERN  HEAP$$Base
        EXTERN  HEAP$$Length
#if defined (__ITCM_PRESENT) && (__ITCM_PRESENT == 1U) && (__ITCM_INIT)
        EXTERN  ITCM$$Base
        EXTERN  ITCM$$Length
#endif
#if defined (__DTCM_PRESENT) && (__DTCM_PRESENT == 1U) && (__DTCM_INIT)
        EXTERN  DTCM$$Base
        EXTERN  DTCM$$Length
#endif
        PUBLIC  __ecc_table_start__
        PUBLIC  __ecc_table_end__
        PUBLIC  __copy_table_start__
        PUBLIC  __copy_table_end__
        PUBLIC  __zero_table_start__
        PUBLIC  __zero_table_end__

;; ECC table
        SECTION  .ecc_tables:CONST(4)

__ecc_table_start__
#ifdef START_FROM_FLASH
        DCD DATA$$Base
        DCD 0
        DCD DATA$$Length
        DCD 0
#endif
        DCD .bss$$Base
        DCD 0
        DCD .bss$$Length
        DCD 0
        DCD CSTACK$$Base
        DCD 0
        DCD CSTACK$$Length
        DCD 0
        DCD HEAP$$Base
        DCD 0
        DCD HEAP$$Length
        DCD 0
#if defined (__ITCM_PRESENT) && (__ITCM_PRESENT == 1U) && (__ITCM_INIT)
        DCD ITCM$$Base
        DCD 0
        DCD ITCM$$Length
        DCD 0
#endif
#if defined (__DTCM_PRESENT) && (__DTCM_PRESENT == 1U) && (__DTCM_INIT)
        DCD DTCM$$Base
        DCD 0
        DCD DTCM$$Length
        DCD 0
#endif
__ecc_table_end__

;; Zero table (initialized in IAR startup)
        SECTION .zero_tables:CONST(4)
__zero_table_start__
        ;DCD .bss$$Base
        ;DCD .bss$$Length
__zero_table_end__

;; Copy table  (initialized in IAR startup)
        SECTION .copy_tables:CONST(4)
__copy_table_start__
        ;DCD .data_init$$Base
        ;DCD DATA$$Base
        ;DCD DATA$$Length
__copy_table_end__

        END
