/* Copyright 2019-2022 NXP */
/* License: BSD 3-clause
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the
       names of its contributors may be used to endorse or promote products
       derived from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
*/
/* File: startup_armv8-r.S
 * Purpose: startup file for armv8-r architecture devices.
 *          Should be used with GCC for ARM Embedded Processors
 */

	.arch	armv8-a

	.section .stack
	.align	3
#ifdef __STACK_SIZE
	.equ	Stack_Size, __STACK_SIZE
#else
	.equ	Stack_Size, 0x00004000
#endif
	.globl	__StackTop
	.globl	__StackLimit
__StackLimit:
	.space	Stack_Size
	.size	__StackLimit, . - __StackLimit
__StackTop:
	.size	__StackTop, . - __StackTop

	.section .heap
	.align	3
#ifdef __HEAP_SIZE
	.equ	Heap_Size, __HEAP_SIZE
#else
	.equ	Heap_Size, 0x0000C000
#endif
	.globl	__HeapBase
	.globl	__HeapLimit
__HeapBase:
	.if	Heap_Size
	.space	Heap_Size
	.endif
	.size	__HeapBase, . - __HeapBase
__HeapLimit:
	.size	__HeapLimit, . - __HeapLimit

	.section .startup
	.align	7
	.globl	Reset_Handler
	.type	Reset_Handler, %function
Reset_Handler:
	// Initialise the register bank - set all the core registers as 64bit zero registers
	mov	x0, xzr
	mov	x1, xzr
	mov	x2, xzr
	mov	x3, xzr
	mov	x4, xzr
	mov	x5, xzr
	mov	x6, xzr
	mov	x7, xzr
	mov	x8, xzr
	mov	x9, xzr
	mov	x10, xzr
	mov	x11, xzr
	mov	x12, xzr
	mov	x13, xzr
	mov	x14, xzr
	mov	x15, xzr
	mov	x16, xzr
	mov	x17, xzr
	mov	x18, xzr
	mov	x19, xzr
	mov	x20, xzr
	mov	x21, xzr
	mov	x22, xzr
	mov	x23, xzr
	mov	x24, xzr
	mov	x25, xzr
	mov	x26, xzr
	mov	x27, xzr
	mov	x28, xzr
	mov	x29, xzr
	mov	x30, xzr

	// Initialize SIMD & FP registers
	movi	d0, #0
	movi	d1, #0
	movi	d2, #0
	movi	d3, #0
	movi	d4, #0
	movi	d5, #0
	movi	d6, #0
	movi	d7, #0
	movi	d8, #0
	movi	d9, #0
	movi	d10, #0
	movi	d11, #0
	movi	d12, #0
	movi	d13, #0
	movi	d14, #0
	movi	d15, #0
	movi	d16, #0
	movi	d17, #0
	movi	d18, #0
	movi	d19, #0
	movi	d20, #0
	movi	d21, #0
	movi	d22, #0
	movi	d23, #0
	movi	d24, #0
	movi	d25, #0
	movi	d26, #0
	movi	d27, #0
	movi	d28, #0
	movi	d29, #0
	movi	d30, #0

/*  Firstly it copies data from read only memory to RAM.
 *  The ranges of copy from/to are specified by following symbols
 *    __etext: LMA of start of the section to copy from. Usually end of text
 *    __data_start__: VMA of start of the section to copy to
 *    __data_end__: VMA of end of the section to copy to
 *
 *  All addresses must be aligned to 4 bytes boundary.
 */

	adrp	x1, :pg_hi21:__etext
	add		x1, x1, :lo12:__etext
	adrp	x2, :pg_hi21:__data_start__
	add		x2, x2, :lo12:__data_start__
	adrp	x3, :pg_hi21:__data_end__
	add		x3, x3, :lo12:__data_end__
	sub		x3, x3, x2
	cbz		x3, .L_loop1_done

.L_loop1:
	ldr		w4, [x1, x0]
	str		w4, [x2, x0]
	add		x0, x0, #4
	cmp		x0, x3
	b.ne	.L_loop1

.L_loop1_done: 

/*  This part of work usually is done in C library startup code. Otherwise,
 *  define __STARTUP_CLEAR_BSS macro to enable it in this startup.
 */
#if defined (__STARTUP_CLEAR_BSS)
/*  The BSS section is specified by following symbols
 *    __bss_start__: start of the BSS section.
 *    __bss_end__: end of the BSS section.
 *
 *  Both addresses must be aligned to 4 bytes boundary.
 */
	adrp	x1, :pg_hi21:__bss_start__
	add		x1, x1, :lo12:__bss_start__
	adrp	x2, :pg_hi21:__bss_end__
	add		x2, x2, :lo12:__bss_end__
	sub		x2, x2, x1
	cbz		x2, .L_loop2_done
	mov		x0, #0

.L_loop2:
	str		wzr, [x1, x0]
	add		x0, x0, #4
	cmp		x0, x2
	b.ne	.L_loop2

.L_loop2_done:
#endif /* __STARTUP_CLEAR_BSS */

#ifndef __START
#define __START _start
#endif
	b	__START
	/* No return here */

	.pool
	.size	Reset_Handler, . - Reset_Handler
