	.arch	armv8-r
	.syntax unified
	$(INSTRUCTION_SET)

	.text
	.align	2
	.globl	SystemInit
	.type	SystemInit, %function
SystemInit:

	/* Vector table initialization */
	ldr	r0, =__EL1_Vectors
	mcr	p15, 0, r0, c12, c0, 0
	ldr	r0, =__EL2_Vectors
	mcr	p15, 4, r0, c12, c0, 0 /* Write to HVBAR */
	/* Clear mask bits A, F, I */
	mrs	r0, cpsr
	ldr	r1, =0xFFFFFE3F
	and	r0, r0, r1
	msr	cpsr, r0
	msr	SPSR_cxsf, r0

	mov	r2, lr					/* save linker so jump back correct */

#ifndef DISABLE_TCM_INITIALIZATION
	/* TCM initialization */
	ldr	r0, =__TCMA_Start		/* Load new BASE address*/
	orr r0, r0, #0x1b			/* 32k; EL0/1=ON L2=ON */
	mcr	p15, 0, r0, c9, c1, 0	/* Write to A-TCM config reg */

	ldr	r0, =__TCMB_Start		/* Load new BASE address */
	orr r0, r0, #0x1b			/* 32k; EL0/1=ON L2=ON */
	mcr	p15, 0, r0, c9, c1, 1	/* Write to B-TCM config reg */

	ldr	r0, =__TCMC_Start		/* Load new BASE address*/
	orr r0, r0, #0x1b			/* 32k; EL0/1=ON L2=ON */
	mcr	p15, 0, r0, c9, c1, 2	/* Write to C-TCM config reg */

	ldr	r0, =__TCMA_Start
	ldr	r1, =__TCMA_Length
	mov	r1, r1, lsr #5			/* Divide by 32 */
	bl	init_tcm_loop

	ldr	r0, =__TCMB_Start
	ldr	r1, =__TCMB_Length
	mov	r1, r1, lsr #5			/* Divide by 32 */
	bl	init_tcm_loop

	ldr	r0, =__TCMC_Start
	ldr	r1, =__TCMC_Length
	mov	r1, r1, lsr #5			/* Divide by 32 */
	bl	init_tcm_loop
#endif

#ifndef DISABLE_CACHE_INITIALIZATION
	/* Enable I cache and D cache for EL2 */
	mrc	p15, 4, r0, c1, c0, 0	/* Read HSCTRL */
	ldr	r1, =0x1004
	orr	r0, r0, r1				/* Set I and C bits */
	mcr	p15, 4, r0, c1, c0, 0	/* Write to HSCTRL reg */

	/* Enable I cache and D cache for EL1/0 */
	mrc	p15, 0, r0, c1, c0, 0	/* Read SCTRL */
	ldr	r1, =0x1004
	orr	r0, r0, r1				/* Set I and C bits */
	mcr	p15, 0, r0, c1, c0, 0	/* Write to SCTRL reg */
#endif

	mov	lr, r2	// bring back first linker saved
	bx	lr

#ifndef DISABLE_TCM_INITIALIZATION
init_tcm_loop:
	stm	r0, {r4-r11}			/* Move 8 location once 4*8=32 bytes */
	add	r0, r0,#32				/* Increment address by 32 */
	sub	r1 ,r1, #1				/* Decrement counter by 1 */
	cmp	r1, #0					/* Is the end of DMEM? */
	bne	init_tcm_loop			/* Restart loop if not */
	bx	lr
#endif
	.pool
	.size	SystemInit, . - SystemInit
