/**
 * Copyright 2020 NXP
 * Created: 27 Aug 2020
 */
package com.nxp.swtools.periphs.gui.dialogs.initializationorder;

import org.eclipse.swt.widgets.Shell;

import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;

/**
 * Properties used within {@link InitializationOrderDialog}
 * @author Tomas Rudolf - nxf31690
 *
 */
public class InitializationOrderDialogProperties {
	/** Parent shell that is used to open new dialog */
	private final Shell shell;
	/** Wrapper of controllers */
	private final IControllerWrapper controllerWrapper;

	/**
	 * Constructor
	 * @param shell parent shell
	 * @param controllerWrapper wrapper of controllers
	 */
	public InitializationOrderDialogProperties(Shell shell, IControllerWrapper controllerWrapper) {
		this.shell = shell;
		this.controllerWrapper = controllerWrapper;
	}

	/**
	 * @return the shell
	 */
	public Shell getShell() {
		return shell;
	}

	/**
	 * @return the profile
	 */
	public PeriphsProfile getRoot() {
		return getControllerWrapper().getController().getProfile();
	}

	/**
	 * @return the wrapper of controllers
	 */
	public IControllerWrapper getControllerWrapper() {
		return controllerWrapper;
	}
}