/**
 * Copyright 2020 NXP
 * Created: 27 Aug 2020
 */
package com.nxp.swtools.periphs.gui.dialogs.initializationorder;

import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;

/**
 * Wrapper containing the instance
 * @author Tomas Rudolf - nxf31690
 */
public class InitializationOrderInstance {
	/** The instance */
	IComponentInstanceConfig instance;
	/** Group wrapper to which this instance belongs */
	InitializationOrderGroup group;

	/**
	 * Constructor
	 * @param instance the actual instance
	 * @param group which contains this instance wrapper
	 */
	InitializationOrderInstance(IComponentInstanceConfig instance, InitializationOrderGroup group) {
		this.instance = instance;
		this.group = group;
	}

	/**
	 * @return the instance
	 */
	public IComponentInstanceConfig getInstance() {
		return instance;
	}

	/**
	 * @return the group
	 */
	public InitializationOrderGroup getGroup() {
		return group;
	}
}