/**
 * Copyright 2019-2021 NXP
 */
package com.nxp.swtools.periphs.gui.expressions;

import java.util.logging.Logger;

import org.eclipse.core.expressions.PropertyTester;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingView;
import com.nxp.swtools.periphs.gui.wrappers.ComponentInstanceWrapper;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;

/**
 * Property tester for IComponentInstanceConfig objects which is provided in selection provider in Component Settings View
 *
 * @author Libor Ukropec
 */
public class ComponentInstanceWrapperPropertyTester extends PropertyTester {

	/** property for instance name */
	private static final String PROPERTY_NAME = "name"; //$NON-NLS-1$
	/** property for instance type id */
	private static final String PROPERTY_ID = "id"; //$NON-NLS-1$
	/** Logger of class */
	private static final Logger LOGGER = LogManager.getLogger(ComponentSettingView.class);

	/**
	 * Constructor
	 */
	public ComponentInstanceWrapperPropertyTester() {
		// intentionally empty
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.expressions.IPropertyTester#test(java.lang.Object, java.lang.String, java.lang.Object[], java.lang.Object)
	 */
	@Override
	public boolean test(Object receiver, String property, Object[] args, @Nullable Object expectedValue) {
		if (expectedValue == null) {
			LOGGER.warning("[TOOL] expected value not defined (null)"); //$NON-NLS-1$
			return false;
		}
		if (receiver instanceof ComponentInstanceWrapper) {
			IComponentInstanceConfig config = ((ComponentInstanceWrapper) receiver).getComponentInstance();
			if (PROPERTY_ID.equals(property)) {
				return config.getComponent().getId().equalsIgnoreCase(expectedValue.toString());
			}
			if (PROPERTY_NAME.equals(property)) {
				return config.getComponentId().equalsIgnoreCase(expectedValue.toString());
			}
		}
		return false;
	}
}
