/**
 * Copyright 2020-2021 NXP
 */
package com.nxp.swtools.periphs.gui.handler;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.gui.perspective.PeripheralsPerspective;
import com.nxp.swtools.utils.httpserver.AHandler;

/**
 * Abstract handler with common function for Peripherals tool HTTP handlers
 * @author Tomas Rudolf - nxf31690
 */
public abstract class AHttpPeriphHandler extends AHandler {

	/** Logger of the class */
	private static final Logger LOGGER = LogManager.getLogger(AHttpPeriphHandler.class);

	/**
	 * Opens Peripherals tool perspective
	 * @return {@code true} when perspective was opened, {@code false} otherwise
	 */
	public boolean openPeripheralsPerspective() {
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
		if (window != null) {
			try {
				workbench.showPerspective(PeripheralsPerspective.ID, window);
				return true;
			} catch (WorkbenchException e) {
				LOGGER.log(Level.SEVERE, "[TOOL] Error when opening Peripherals tool perspective: {0}", e.getLocalizedMessage()); //$NON-NLS-1$
				return false;
			}
		}
		return false;
	}
	
}
