/*
 * Copyright 2020-2021 NXP
 */
package com.nxp.swtools.periphs.gui.handler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewSite;

import com.nxp.swtools.periphs.gui.controller.PeriphControllerWrapper;
import com.nxp.swtools.periphs.gui.view.AddComponentDialog;
import com.nxp.swtools.periphs.gui.view.AddComponentDialogProperties;
import com.nxp.swtools.utils.httpserver.HttpRequest;
import com.nxp.swtools.utils.httpserver.Response;

/**
 * Handler that will open {@link AddComponentDialog} when there will be HTTP request
 * @author Tomas Rudolf - nxf31690
 */
public class HttpOpenAddComponentDialogHandler extends AHttpPeriphHandler {
	/** Id of regex group that matches the peripheral instance */
	private static final String REGEX_PERIPHERAL_GROUP_ID = "peripheral"; //$NON-NLS-1$
	/** This handler handles queries that starts with this prefix */
	private static final String PREFIX = "/periph/openAddComponentDialog"; //$NON-NLS-1$
	/** Pattern to match specific peripheral request */
	private static final Pattern pattern = Pattern.compile(PREFIX + "/(?<" + REGEX_PERIPHERAL_GROUP_ID + ">\\w+)"); //$NON-NLS-1$ //$NON-NLS-2$

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.httpserver.IHandler#canHandle(com.nxp.swtools.utils.httpserver.HttpRequest)
	 */
	@Override
	public boolean canHandle(HttpRequest query) {
		if (query.getLocation().startsWith(PREFIX)) {
			return true;
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.httpserver.IHandler#handle(com.nxp.swtools.utils.httpserver.HttpRequest)
	 */
	@Override
	public void handle(HttpRequest query) {
		PeriphControllerWrapper wrapper = PeriphControllerWrapper.getInstance();
		Display display = wrapper.getController().getDisplay();
		if (display == null) {
			query.setResponse(new Response(Response.STATUS_CODE_INTERNAL_ERROR, "Could not retrieve display")); //$NON-NLS-1$
			return;
		}
		display.asyncExec(() -> {
			putShellToTop();
			openPeripheralsPerspective();
			IViewSite currentViewSite = wrapper.getGUIController().getCurrentViewSite();
			if (currentViewSite == null) {
				query.setResponse(new Response(Response.STATUS_CODE_INTERNAL_ERROR, "Could not retrieve current view site")); //$NON-NLS-1$
				return;
			}
			Matcher matcher = pattern.matcher(query.getLocation());
			String peripheral = null;
			if (matcher.matches()) {
				peripheral = matcher.group(REGEX_PERIPHERAL_GROUP_ID); 
			}
			AddComponentDialogProperties properties = new AddComponentDialogProperties(currentViewSite, wrapper.getController().getFunctionalGroup().getId(), wrapper, true, true);
			properties.setBlockOnOpen(false);
			if (peripheral != null) {
				properties.setPeripheral(peripheral);
			}
			AddComponentDialog.open(properties);
			query.setResponse(new Response(Response.STATUS_CODE_OK, "OK")); //$NON-NLS-1$
		});
	}
}
