/**
 * Copyright 2021 NXP
 * Created: Sep 9 2021
 */
package com.nxp.swtools.periphs.gui.handler;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.periphs.gui.controller.PeriphControllerWrapper;
import com.nxp.swtools.periphs.gui.perspective.PeripheralsPerspective;
import com.nxp.swtools.periphs.gui.view.MigrationOfferDialog;

/**
 * Helper for delayed opening of {@link MigrationOfferDialog}
 * @author Tomas Rudolf - nxf31690
 */
public class MigrationOfferDialogHelper {
	/** Information whether the {@link MigrationOfferDialog} should be opened later */
	private static boolean delayedOpen;

	/**
	 * Constructor
	 */
	private MigrationOfferDialogHelper() {
		// Intentionally empty
	}

	/**
	 * Call when Peripherals perspective was activated
	 */
	public static void perspectiveActivated() {
		IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if (window == null) {
			return;
		}
		Shell shell = window.getShell();
		if (delayedOpen && (shell != null)) {
			openDialogIfAnyMigrationIsAvailable(shell);
			delayedOpen = false;
		}
	}

	/**
	 * Opens {@link MigrationOfferDialog} if it should be open
	 * @param shell in which the dialog should open
	 */
	private static void openDialogIfAnyMigrationIsAvailable(Shell shell) {
		if (!MigrationOfferDialog.shouldMigrationOfferDialogopenAutomatically(PeriphControllerWrapper.getInstance())) {
			return;
		}
		MigrationOfferDialog.open(shell, PeriphControllerWrapper.getInstance());
	}

	/**
	 * Call to open the {@link MigrationOfferDialog} right now or later when Peripherals perspective will be active
	 */
	public static void openNowOrWhenPeripheralsPerspectiveIsActive() {
		UIJobHelper.runUIJob(() -> {
			IWorkbench workbench = PlatformUI.getWorkbench();
			IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
			if (activeWorkbenchWindow == null) {
				return;
			}
			IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
			if (activePage == null) {
				return;
			}
			IPerspectiveDescriptor perspective = activePage.getPerspective();
			if (perspective == null) {
				return;
			}
			String perspectiveId = perspective.getId();
			if (PeripheralsPerspective.ID.equals(perspectiveId)) {
				// React right now
				Shell shell = activeWorkbenchWindow.getShell();
				if (shell == null) {
					return;
				}
				openDialogIfAnyMigrationIsAvailable(shell);
			} else {
				delayedOpen = true;
			}
		}, "Open migration offer dialog", false, null, 500); //$NON-NLS-1$
	}

}
