/**
 * Copyright 2017-2020 NXP
 */
package com.nxp.swtools.periphs.gui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.controller.PeriphControllerWrapper;
import com.nxp.swtools.periphs.gui.dialogs.initializationorder.InitializationOrderDialog;
import com.nxp.swtools.periphs.gui.dialogs.initializationorder.InitializationOrderDialogProperties;

/**
 * Handler used for refreshing the state.
 * @author Juraj Ondruska
 */
public class OpenInitializationOrderDialogHandler extends AbstractHandler {

	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.IHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	@Override
	public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
		IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if (activeWorkbenchWindow == null) {
			return null;
		}
		Shell shell = activeWorkbenchWindow.getShell();
		if (shell == null) {
			return null;
		}
		InitializationOrderDialogProperties properties = new InitializationOrderDialogProperties(shell, PeriphControllerWrapper.getInstance());
		InitializationOrderDialog.open(properties);
		return null;
	}

}
