/**
 * Copyright 2017-2020 NXP
 */
package com.nxp.swtools.periphs.gui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.view.DocumentationView;
import com.nxp.swtools.utils.profiler.Profiler;

/**
 * Handler used for refreshing the state.
 * @author Juraj Ondruska
 */
public class RefreshHandler extends AbstractHandler {

	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.IHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	@Override
	public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
		Profiler.getInstance(SwToolsProduct.PRODUCT_ID_PERIPHERALS_TOOL).flush();
		Controller.getInstance().refresh();
		DocumentationView.refresh();
		return null;
	}

}
