/**
 * Copyright 2022 NXP
 */
package com.nxp.swtools.periphs.gui.view;

import java.util.function.Predicate;

import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.data.documentation.Contents;
import com.nxp.swtools.resourcetables.model.data.documentation.ISectionsProvider;
import com.nxp.swtools.resourcetables.model.data.documentation.Section;

/**
 * Helper class for {@link DocumentationView}
 * @author Tomas Rudolf - nxf31690
 */
@NonNullByDefault
public class DocumentationViewHelper {
	/**
	 * Hidden private constructor
	 */
	private DocumentationViewHelper() {
		// Intentionally empty
	}

	// FIXME TomasR v13 maintenance - Move functions with potential generic usage from DocumenationView here

	/**
	 * Returns the name of the page based on the name of the page file
	 * @param child from which the instance is obtained
	 * @param pageFile name of the page file
	 * @return name of the page or {@code null} when the child is not in instance, the instance does not contain documentation content file
	 *  or there is no page with given file name in the documentation content file
	 */
	public static @Nullable String getNameOfPage(IChild child, String pageFile) {
		IComponentInstanceConfig instance = child.getChildContext().getComponentInstanceConfig();
		if (instance == null) {
			return null;
		}
		Contents documentationMenuContent = instance.getConfigCompTypeId().getDocumentationMenuContent();
		if (documentationMenuContent == null) {
			return null;
		}
		Predicate<Section> predicate = s -> s.getFile().equals(pageFile);
		Section section = findSectionByPredicate(documentationMenuContent, predicate);
		if (section == null) {
			return null;
		}
		return section.getName();
	}

	/**
	 * Finds section recursively by checking predicate
	 * @param sectionsProvider provider of sections
	 * @param predicate to test section
	 * @return section that matches predicate, if none matches then {@code null} is returned
	 */
	public static @Nullable Section findSectionByPredicate(@Nullable ISectionsProvider sectionsProvider, Predicate<Section> predicate) {
		if (sectionsProvider == null) {
			return null;
		}
		for (Section section : sectionsProvider.getSections()) {
			if (predicate.test(section)) {
				return section;
			}
			if (section.hasSubSections()) {
				Section search = findSectionByPredicate(section, predicate);
				if (search != null) {
					return search;
				}
			}
		}
		return null;
	}
}