/**
 * Copyright 2017-2020 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.utils.TestIDs;

/**
 * Class representing control of a check-box setting configuration.
 * @author Juraj Ondruska
 */
public class ScalarCheckboxControl extends ScalarControl {

	/**
	 * @param child to create control for
	 * @param controlOptions for this control
	 * @param controllerWrapper containing the generic controller
	 */
	public ScalarCheckboxControl(@NonNull ScalarConfig child, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
		super(child, controlOptions, controllerWrapper);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase#create(org.eclipse.swt.widgets.Composite, int)
	 */
	@Override
	public void create(@NonNull Composite composite, int colSpan) {
		super.create(composite, colSpan);
		// make checkbox react only when clicked directly on it - don't react when clicked on an empty space next to a checkbox
		if (mainControl != null) {
			mainControl.setLayoutData(new GridDataComponents(SWT.LEFT, SWT.CENTER, true, false, colSpan - 1, 1));
		}
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.editor.ScalarControl#createMainControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @NonNull Control createMainControl(@NonNull Composite composite) {
		final Composite buttonComposite = new Composite(composite, SWT.NONE);
		GridLayoutComponents buttonCompositeLayout = new GridLayoutComponents();
		buttonCompositeLayout.marginWidth = buttonCompositeLayout.marginHeight = 0;
		buttonComposite.setLayout(buttonCompositeLayout);
		Button button = new Button(buttonComposite, SWT.CHECK);
		button.setLayoutData(new GridDataComponents(SWT.LEFT, SWT.CENTER, true, false));
		SWTFactoryProxy.INSTANCE.setTestId(button, TestIDs.PERIPHS_SETTING_CONTROL + child.getId());
		mainControlInternal = button;
		button.addSelectionListener(new SelectionAdapter() {
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			@Override
			public void widgetSelected(SelectionEvent e) {
				changeModelValue(UtilsText.safeString(Boolean.toString(button.getSelection())));
			}
		});
		createErrorDecoration(button, SWT.LEFT | SWT.TOP);
		return buttonComposite;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ScalarControl#updateMainContent(org.eclipse.swt.widgets.Control, com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType)
	 */
	@Override
	protected void updateMainContent(@NonNull Control contentControl, UpdateType updateType) {
		if ((updateType != UpdateType.PROBLEM_DECORATION) && (mainControlInternal != null)) {
			((Button) mainControlInternal).setSelection(Boolean.parseBoolean(child.getValue().toString()));
		}
		if (mainControlInternal != null) {
			updateErrorDecoration(mainControlInternal);
		}
		updateErrorDecoration(contentControl);

	}
}
