/**
 * Copyright 2019-2020 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.resourcetables.model.config.StructConfig;

/**
 * Class representing control of a struct setting configuration with multiple columns.
 * @author Tomas Rudolf - nxf31690
 */
public class StructMultiColumnControl extends StructControl {
	/** Map of composites for each children */
	private Map<IChildControl, Composite> composites = new HashMap<>();

	/**
	 * @param structConfig to create control for
	 * @param controlOptions for this control
	 * @param controllerWrapper containing the generic controller
	 */
	public StructMultiColumnControl(@NonNull StructConfig structConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
		super(structConfig, controlOptions, controllerWrapper);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase#createMainControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @Nullable Control createMainControl(@NonNull Composite composite) {
		int columns = 1;
		if (getControlOptions().isMultiColumn()) {
			Integer numOfColumns = getControlOptions().getNumOfColumns();
			if (numOfColumns != null) {
				columns = numOfColumns.intValue();
			}
		}
		int swtStyle = getSwtStyle(this);
		Composite contentComposite = new Composite(composite, swtStyle);
		GridLayoutComponents contentCompositeLayout = new GridLayoutComponents(columns, false);
		if ((swtStyle & SWT.BORDER) == 0) {
			contentCompositeLayout.marginHeight = 0;
			contentCompositeLayout.marginWidth = 0;
		}
		contentComposite.setLayout(contentCompositeLayout);
		for (IChildControl childControl : children) {
			Composite c = new Composite(contentComposite, SWT.NONE);
			composites.put(childControl, c);
			GridLayoutComponents layout = new GridLayoutComponents(ComponentSettingView.CONFIG_SET_COLS, false);
			layout.marginHeight = 0;
			layout.marginWidth = 0;
			c.setLayout(layout);
			c.setLayoutData(new GridDataComponents(SWT.FILL, SWT.FILL, true, false));
			childControl.create(c, ComponentSettingView.CONFIG_SET_COLS);
		}
		return contentComposite;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase#updateMainContent(org.eclipse.swt.widgets.Control, com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType)
	 */
	@Override
	protected void updateMainContent(@NonNull Control contentControl, @NonNull UpdateType updateType) {
		super.updateMainContent(contentControl, updateType);
		for (Entry<IChildControl, Composite> entry : composites.entrySet()) {
			Composite composite = entry.getValue();
			GridDataComponents layoutData = (GridDataComponents) composite.getLayoutData();
			if (layoutData != null) {
				boolean visible = entry.getKey().getChild().isAvailable();
				layoutData.exclude = !visible;
				composite.setVisible(visible);
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.StructControl#dispose()
	 */
	@Override
	public void dispose() {
		super.dispose();
		composites.clear();
	}
}
