/**
 * Copyright 2017-2020 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingView;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;

/**
 * Class represents standard array GUI representation with items as rows.
 * @author Juraj Ondruska
 */
public class ArrayControlStandardVertical extends AArrayControlStandard {

	/**
	 * Constructor.
	 * @param arrayConfig for which to create the GUI
	 * @param controlOptions for this control
	 * @param controllerWrapper containing the generic controller
	 */
	protected ArrayControlStandardVertical(@NonNull ArrayConfig arrayConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
		super(arrayConfig, controlOptions, controllerWrapper);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlStandard#createMainControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @NonNull Control createMainControl(@NonNull Composite composite) {
		Composite contentComposite = createComposite(composite, ComponentSettingView.CONFIG_SET_COLS);
		super.createMainControl(contentComposite);
		return contentComposite;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlInternal#updateMainContent(org.eclipse.swt.widgets.Control, com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType)
	 */
	@Override
	public void updateMainContent(@NonNull Control contentControl, @NonNull UpdateType updateType) {
		boolean layoutChange = updateMainCommonImpl(updateType, (Composite) contentControl);
		if (layoutChange) {
			contentControl.requestLayout();
		}
		updateErrorDecoration(contentControl);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlStandard#disposeChild(com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl)
	 */
	@Override
	protected void disposeChild(IChildControl childControl) {
		childControl.dispose();
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlStandard#createItem(org.eclipse.swt.widgets.Composite, com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl)
	 */
	@Override
	protected void createItem(@NonNull Composite compositeForItem, @NonNull IChildControl childControl) {
		createItemGui(childControl, compositeForItem, ComponentSettingView.CONFIG_SET_COLS - 1);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlStandard#recreateAddButton(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected void recreateAddButton(@NonNull Composite composite) {
		createAddButton(composite, ComponentSettingView.CONFIG_SET_COLS);
	}
}
