/**
 * Copyright 2019-2021 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import com.nxp.swtools.common.ui.utils.swt.ScrolledCompositeHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingView;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.resources.IToolsImages;
import com.nxp.swtools.utils.resources.ToolsImages;

/**
 * Class representing tabs representation of an array config with items represented as tabs.
 * @author Tomas Rudolf - nxf31690
 */
public class ArrayControlTabs extends AArrayControlGroup {
	/** Composite with content */
	private @Nullable Composite contentComposite;	
	
	/**
	 * Constructor.
	 * @param arrayConfig for which to create the table
	 * @param controlOptions for this control
	 * @param controllerWrapper containing the generic controller
	 */
	protected ArrayControlTabs(@NonNull ArrayConfig arrayConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
		super(arrayConfig, controlOptions, controllerWrapper);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlGroup#createLabelControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public Control createLabelControl(Composite composite) {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlInternal#getSelection()
	 */
	@Override
	public ISettingConfig getSelection() {
		IChildControl selectedChildLoc = getSelectedChild();
		if (selectedChildLoc == null) {
			return null;
		}
		IChild childLoc = selectedChildLoc.getChild();
		if (childLoc instanceof ISettingConfig) {
			return (ISettingConfig) childLoc;
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlInternal#getMoveDownDescription()
	 */
	@Override
	protected @NonNull String getMoveDownDescription() {
		return Messages.get().ArrayControl_ItemMenu_MoveRight;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlInternal#getMoveUpButtonDescription()
	 */
	@Override
	protected @NonNull String getMoveUpButtonDescription() {
		return Messages.get().ArrayControl_ItemMenu_MoveLeft;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlInternal#createMainControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @Nullable Control createMainControl(@NonNull Composite composite) {
		boolean borderHidden = getControlOptions().isBorderHidden();
		getControlOptions().borderHidden(true);
		int colSpan = 1;
		Composite createdComposite = createComposite(composite, colSpan);
		getControlOptions().borderHidden(borderHidden);
		createLabelWithControls(createdComposite);
		contentComposite = createControlTabs(createdComposite, ComponentSettingView.CONFIG_SET_COLS, new SelectionAdapter() {
			/*
			 * (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			@Override
			public void widgetSelected(SelectionEvent e) {
				updateChildSelection(ComponentSettingView.CONFIG_SET_COLS);
				updateButtons(getControlUpdateType());
				Composite contentCompositeLoc = contentComposite;
				if (contentCompositeLoc != null) {
					ScrolledCompositeHelper.updateScrollSize(contentCompositeLoc);
				}
			}
		});
		createInfoLabel(createdComposite, colSpan);
		return createdComposite;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase#updateSelectionOfExpandGroupContent()
	 */
	@Override
	protected void updateSelectionOfExpandGroupContent() {
		// if no child in table, set the expand control instance null, otherwise set the contentComposite instance
		if (children.isEmpty()) {
			setSelectedChild(null);
			expandGroupContent = null;
		} else {
			expandGroupContent = contentComposite;
		}
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlInternal#updateMainContent(org.eclipse.swt.widgets.Control, com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType)
	 */
	@Override
	public void updateMainContent(@NonNull Control mainControlLoc, @NonNull UpdateType updateType) {
		Composite contentCompositeLoc = contentComposite;
		if (contentCompositeLoc != null) {
			Point size = contentCompositeLoc.getSize();
			boolean isChanged = !size.equals(new Point(0, 0));
			if (KEPreferences.isAnimationsEnabled() && isChanged && updateType == UpdateType.NORMAL && (children.isEmpty() || (children.size() == 1 && !contentCompositeLoc.isVisible()))) {
				setControlVisibleAnimation(contentCompositeLoc, null, !children.isEmpty());
			} else {
				setControlVisible(contentCompositeLoc, !children.isEmpty());
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlGroup#updateButtons(com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType)
	 */
	@Override
	protected void updateButtons(@Nullable UpdateType updateType) {
		if (!areButtonsEnabled()) {
			updateType = UpdateType.FORCE_DISABLE;
		}
		updateAddButton(updateType);
		updateRemoveButton(updateType);
		updateDownButton(updateType);
		updateUpButton(updateType);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlInternal#setAllSettingsTo(com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlItemMenu, com.nxp.swtools.periphs.gui.view.componentsettings.internal.IArrayControlItemMenuControl)
	 */
	@Override
	public void setAllSettingsTo(@NonNull ArrayControlItemMenu caller, @NonNull IArrayControlItemMenuControl control) {
		// Not applicable in this GUI representation
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlInternal#selectLastItem()
	 */
	@Override
	public void selectLastItem() {
		int lastIndex = children.size() - 1;
		if (lastIndex >= 0) {
			setSelectedChild(children.get(lastIndex));
			updateTabs();
			updateButtons(getControlUpdateType());
		}
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlInternal#getMoveUpIcon()
	 */
	@Override
	protected @Nullable Image getMoveUpIcon() {
		return ToolsImages.getImage(IToolsImages.ICON_LEFT);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlInternal#getMoveDownIcon()
	 */
	@Override
	protected @Nullable Image getMoveDownIcon() {
		return ToolsImages.getImage(IToolsImages.ICON_RIGHT);
	}
}
