/**
* Copyright 2018,2020 NXP
* Created: Feb 8, 2018
*/
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import org.eclipse.swt.widgets.Menu;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.view.componentsettings.ArrayControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType;
import com.nxp.swtools.resourcetables.model.config.IChild;

/**
 * Prototype for item menu controls in {@link ArrayControl} 
 * @author Viktar Paklonski
 */
public interface IArrayControlItemMenuControl {
	/**
	 * Destroys private members.
	 */
	public void dispose();

	/**
	 * @return context menu
	 */
	public @NonNull Menu getMenu();

	/**
	 * @return selected item control
	 */
	public @Nullable IChildControl getSelectedItemHint();
	
	/**
	 * @return selected setting of the selected item
	 */
	default public @Nullable IChild getSelectedSettingHint() {
		return null;
	}

	/**
	 * Refreshes menu button and action availability.
	 * @param updateType or {@code null} if update type is unknown
	 */
	public void update(@Nullable UpdateType updateType);
}
