/**
 * Copyright 2017-2019 NXP
 */
package com.nxp.swtools.periphs.gui.view.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IProblemResolveHandler;
import com.nxp.swtools.validation.engine.IProblemResolveProvider;

/**
 * Class for providing resolution handlers for {@link IBaseProblem} in the Peripherals tool.
 * @author Juraj Ondruska
 */
public class PeripheralsProblemResolveProvider implements IProblemResolveProvider {
	/** All available peripheral problem resolve handlers */
	private static final @NonNull List<@NonNull IPeripheralsProblemResolveHandler> HANDLERS;
	static {
		HANDLERS = new ArrayList<>();
		HANDLERS.add(PeripheralInitResolveHandler.INSTANCE);
		HANDLERS.add(PeripheralEnableResolveHandler.INSTANCE);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.validation.engine.IProblemResolveProvider#getResolveHandlers(com.nxp.swtools.validation.engine.IBaseProblem)
	 */
	@Override
	public @NonNull Collection<@NonNull IProblemResolveHandler> getResolveHandlers(@NonNull IBaseProblem problem) {
		ArrayList<@NonNull IProblemResolveHandler> result = new ArrayList<>();
		for (IPeripheralsProblemResolveHandler handler : HANDLERS) {
			if (handler.canHandle(problem)) {
				result.add(handler);
			}
		}
		return result;
	}

}
