 /**
 * Copyright 2019-2020 NXP
 * Created: Mar 13, 2019
 */

package com.nxp.swtools.periphs.gui.wrappers;

import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;

/**
 * Wrapper with component instance and controller wrapper which contains controller that manages this component instance
 * @author Tomas Rudolf - nxf31690
 */
public class ComponentInstanceWrapper {
	/** Component instance config */
	private IComponentInstanceConfig componentInstanceConfig;
	/** Wrapper with controller that manages this component instance */
	private IControllerWrapper controllerWrapper;

	/**
	 * Constructor
	 * @param config instance of component
	 * @param controllerWrapper with controller that manages given component instance
	 */
	public ComponentInstanceWrapper(IComponentInstanceConfig config, IControllerWrapper controllerWrapper) {
		this.componentInstanceConfig = config;
		this.controllerWrapper = controllerWrapper;
	}

	/**
	 * Returns component instance
	 * @return component instance
	 */
	public IComponentInstanceConfig getComponentInstance() {
		return componentInstanceConfig;
	}

	/**
	 * Returns wrapper with controller for this component instance
	 * @return wrapper with controller
	 */
	public IControllerWrapper getControllerWrapper() {
		return controllerWrapper;
	}
}
