/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Libor Ukropec (Freescale) - code customized for Processor Expert
 *******************************************************************************/

package com.nxp.swtools.derivative.swt;

import java.text.MessageFormat;

import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class DialogCellEditorAdvanced extends DialogCellEditor {
	
	static final long serialVersionUID = 1L;

	/** Escape character */
	final static char ESC_CHAR = '\u001b';
	
	protected Button[] buttons;
	
	private FocusListener buttonFocusListener;

    /**
     * The editor control.
     */
    private Composite editor;

    /**
     * The current contents.
     */
    Control contents;

    /**
     * The value of this cell editor; initially <code>null</code>.
     */
    private Object value = null;


	public DialogCellEditorAdvanced(Composite parent) {
		super(parent);
	}

	/**
	 * Helper class extending KeyAdapter, used in com.nxp.swtools.derivative.swt.DialogCellEditorAdvanced.createControl(Composite)
	 */
	class DlgCellEditKeyAdapter extends KeyAdapter {

		/** For serialization */
		static final long serialVersionUID = 1L;

		/* (non-Javadoc)
         * @see org.eclipse.swt.events.KeyListener#keyReleased(org.eclipse.swt.events.KeyEvent)
         */
        @Override
		public void keyReleased(KeyEvent e) {
			if (e.character == ESC_CHAR) fireCancelEditor();
        }
    }
	
	/**
	 * Helper class extending SelectionAdapter; used in com.nxp.swtools.derivative.swt.DialogCellEditorAdvanced.createControl(Composite)
	 */
	class DlgCellEditSelectionAdapter extends SelectionAdapter {
		
		/** For serialization */
		static final long serialVersionUID = 1L;

		/* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
         */
        @Override
		public void widgetSelected(SelectionEvent event) {
        	Button button = (Button)event.widget;
        	// remove focus listener
        	button.removeFocusListener(getButtonFocusListener());
        	Object newValue = openDialogBox(editor, button);
        	// now add it again
        	button.addFocusListener(getButtonFocusListener());
        	//
        	if (newValue != null) {
                if (isCorrect(newValue)) {
                    markDirty();
                    doSetValue(newValue);
                } else {
                    // report issue with the new value.
                    setErrorMessage(MessageFormat.format(getErrorMessage(), new Object[] { newValue.toString() }));
                }
                fireApplyEditorValue();
            }
        }
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.DialogCellEditor#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();

        editor = new Composite(parent, getStyle());
        editor.setFont(font);
        editor.setBackground(bg);
        editor.setLayout(new MyDialogCellLayout());

        contents = createContents(editor);
        updateContents(value);

        buttons = createButtons(editor);
        
		if (buttons != null) {
			for(int i = 0; i < buttons.length; i++) {
				Button btn;
				btn = buttons[i];
				btn.setFont(parent.getFont());
				btn.addFocusListener(getButtonFocusListener());
				btn.addKeyListener(new DlgCellEditKeyAdapter());				
				btn.addSelectionListener(new DlgCellEditSelectionAdapter());
			}
		}
		editor.setLayout(new MyDialogCellLayout());
        return editor;
    }

	protected Button[] createButtons(Composite parent) {
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.DialogCellEditor#createButton(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Button createButton(Composite parent) {
		return super.createButton(parent);
	}

    /**
     * Internal class for laying out the dialog.
     */
    class MyDialogCellLayout extends Layout {

		static final long serialVersionUID = 1L;

		/* (non-Javadoc)
         * @see org.eclipse.swt.widgets.Layout#layout(org.eclipse.swt.widgets.Composite, boolean)
         */
        @Override
		public void layout(Composite composite, boolean force) {
            Rectangle bounds = composite.getClientArea();
            if (buttons != null) {
            	for(int i=0; i < buttons.length; i++) {
            		Point size = buttons[i].computeSize(SWT.DEFAULT, SWT.DEFAULT, force);
            		bounds.width -= size.x;
            		buttons[i].setBounds(bounds.width, 0, size.x, bounds.height);
            	}
            }
            if (contents != null) {
				contents.setBounds(bounds);
			}
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.widgets.Layout#computeSize(org.eclipse.swt.widgets.Composite, int, int, boolean)
         */
        @Override
		public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != SWT.DEFAULT && hHint != SWT.DEFAULT) {
				return new Point(wHint, hHint);
			}
            int xSize = 0;
            int ySize = 0;
            if (buttons != null) {
            	for(int i=0; i < buttons.length; i++) {
            		Point size = buttons[i].computeSize(SWT.DEFAULT, SWT.DEFAULT, force);
            		xSize += size.x;
            		ySize = Math.max(ySize, size.y);
            	}
            }
            // Just return the button width to ensure the button is not clipped
            // if the label is long.
            // The label will just use whatever extra width there is
            return new Point(xSize, ySize);
        }
    }

    /**
     * Helper class implementing FocusListener, used in com.nxp.swtools.derivative.swt.DialogCellEditorAdvanced.getButtonFocusListener()
     */
    class DlgCellEditFocusListener implements FocusListener {
    	
		/** For serialization */
		static final long serialVersionUID = 1L;

		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.FocusListener#focusGained(org.eclipse.swt.events.FocusEvent)
		 */
		public void focusGained(FocusEvent e) {
			// Do nothing
		}

		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.FocusListener#focusLost(org.eclipse.swt.events.FocusEvent)
		 */
		public void focusLost(FocusEvent e) {
			DialogCellEditorAdvanced.this.focusLost();
		}
    }
    
    /**
     * Return a listener for button focus.
     * @return FocusListener
     */
    private FocusListener getButtonFocusListener() {
    	if (buttonFocusListener == null) {
    		buttonFocusListener = new DlgCellEditFocusListener();
    	}
    	
    	return buttonFocusListener;
	}

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.DialogCellEditor#openDialogBox(org.eclipse.swt.widgets.Control)
     */
    /** @param button
	 *            the button that was pressed; one of the buttons returned from
	 *            {@link #createButtons(Composite)}
	 */
    protected abstract Object openDialogBox(Control cellEditorWindow, Button button);
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.DialogCellEditor#openDialogBox(org.eclipse.swt.widgets.Control)
     */
    @Override
	protected Object openDialogBox(Control cellEditorWindow) {
    	assert false : "not expecting this to ever get called; the variant that takes a Button is the operative method"; //$NON-NLS-1$
    	return null;
    }
}
