/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.internal.s32debugger.launch.checkers;

import com.nxp.s32ds.cle.debug.s32debugger.ResolverUtils;
import com.nxp.s32ds.cle.debug.s32debugger.S32DebuggerActivator;
import com.nxp.s32ds.cle.debug.s32debugger.launch.markers.S32DebuggerLaunchConfigurationScriptMarker;
import com.nxp.s32ds.ext.cdt.checkers.core.CdtLaunchConfigurationAbstractChecker;
import com.nxp.s32ds.ext.cdt.core.checker.IResourceChecker;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;

public class S32DebuggerLaunchConfigurationScriptPathChecker
extends CdtLaunchConfigurationAbstractChecker
implements IResourceChecker {
    public IStatus check(IResource resource, IProgressMonitor monitor) {
        return this.checkLaunchConfigurationFiles(resource);
    }

    protected IStatus check(List<IFile> listLaunchFiles, IProject project) {
        MultiStatus ms = new MultiStatus(S32DebuggerActivator.getInstance().getBundleId(), 0, "", null);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        for (IFile launchFile : listLaunchFiles) {
            if (!launchFile.exists()) continue;
            ILaunchConfiguration launchConfiguration = launchManager.getLaunchConfiguration(launchFile);
            try {
                String lcType = launchConfiguration.getType().getIdentifier();
                if (!"com.nxp.s32ds.debug.ide.s32debugger.core.s32DebuggerLaunchConfigurationType".equals(lcType) && !"com.nxp.s32ds.debug.ide.s32debugger.flash.core.s32DebuggerFlashProgrammerLaunchConfigurationType".equals(lcType) || !S32DebuggerLaunchConfigurationScriptPathChecker.hasDeprecatedScriptPath(launchConfiguration) || S32DebuggerLaunchConfigurationScriptMarker.containsMarker((IResource)launchFile)) continue;
                ms.add(S32DebuggerLaunchConfigurationScriptMarker.createMarker((IResource)launchFile, project));
            }
            catch (CoreException ce) {
                S32DebuggerActivator.getInstance().log(ce.getStatus());
            }
        }
        return ms;
    }

    private static boolean hasDeprecatedScriptPath(ILaunchConfiguration launchConfiguration) throws CoreException {
        String scriptValue;
        if (launchConfiguration.hasAttribute("com.nxp.s32ds.debug.ide.s32debugger.core.initializationScriptPath") && !(scriptValue = launchConfiguration.getAttribute("com.nxp.s32ds.debug.ide.s32debugger.core.initializationScriptPath", "")).isEmpty()) {
            String scriptName = new Path(scriptValue).toFile().getName();
            Map<String, String> prefixesToResolve = ResolverUtils.getResolvingPrefixesMap();
            Optional<String> prefix = prefixesToResolve.keySet().stream().filter(p -> scriptName.startsWith((String)p)).findAny();
            if (prefix.isPresent()) {
                return !scriptName.startsWith(prefixesToResolve.get(prefix.get()));
            }
        }
        return false;
    }
}

