/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.s32debugger;

import com.nxp.s32ds.cle.debug.s32debugger.S32DebuggerActivator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ResolverUtils {
    public static final String PREFIX_BACKUP = "backup_";
    public static final String INIT_SCRIPT_ATTRIBUTE = "com.nxp.s32ds.debug.ide.s32debugger.core.initializationScriptPath";
    public static final String DEBUG_NAME_ATTRIBUTE = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";
    private static final Map<String, String> SCRIPT_PREFIX_TO_UPDATE = new HashMap<String, String>();
    public static final String PREFIX_REGEXP_POSTFIX = ".{2,3}_";

    static {
        SCRIPT_PREFIX_TO_UPDATE.put("s32g2", "s32g2xx_");
    }

    public static Path createBackUpLaunchFile(IFile launchConfigFile) {
        String relativeBackupFilePath = ResolverUtils.addBackupToPath(launchConfigFile.getFullPath().toString(), launchConfigFile.getName());
        Path backupPath = new Path(relativeBackupFilePath);
        try {
            launchConfigFile.copy((IPath)backupPath, true, null);
        }
        catch (CoreException ce) {
            S32DebuggerActivator.getInstance().log(ce.getStatus());
            backupPath = null;
        }
        return backupPath;
    }

    private static String addBackupToPath(String path, String configurationName) {
        int nameIndex = path.lastIndexOf(configurationName);
        return String.valueOf(path.substring(0, nameIndex)) + PREFIX_BACKUP + path.substring(nameIndex);
    }

    public static Map<String, String> getResolvingPrefixesMap() {
        return Collections.unmodifiableMap(SCRIPT_PREFIX_TO_UPDATE);
    }
}

