/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.group.launch.ui;

import com.nxp.s32ds.debug.ide.s32debugger.group.launch.S32DebuggerSingleLaunchElement;
import com.nxp.s32ds.debug.ide.s32debugger.group.launch.providers.S32DebuggerGroupCheckStateProvider;
import com.nxp.s32ds.debug.ide.s32debugger.group.launch.providers.S32DebuggerGroupContentProvider;
import com.nxp.s32ds.debug.ide.s32debugger.group.launch.providers.S32DebuggerGroupLaunchLabelProvider;
import com.nxp.s32ds.debug.ide.s32debugger.group.launch.ui.S32DebuggerGroupLaunchConfigurationSelectionDialog;
import com.nxp.s32ds.debug.ide.s32debugger.group.launch.ui.S32DebuggerGroupLaunchMessages;
import com.nxp.s32ds.debug.ide.s32debugger.group.launch.ui.S32DebuggerTabGroupButtonComposite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class S32DebuggerGroupLaunchTab
extends AbstractLaunchConfigurationTab {
    private CheckboxTreeViewer treeViewLaunches;
    private List<S32DebuggerSingleLaunchElement> singleLaunches = new ArrayList<S32DebuggerSingleLaunchElement>();
    private String mode;
    private final int COLUMN_LC_NAME_WIDTH = 400;
    private final int COLUMN_LAUNCH_MODE_WIDTH = 50;
    private final int COLUMN_AFTER_LAUNCH_ACTION_WIDTH = 175;

    public S32DebuggerGroupLaunchTab(String mode) {
        this.mode = mode;
    }

    public void createControl(Composite parent) {
        Composite layout = new Composite(parent, 0);
        layout.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)layout);
        this.treeViewLaunches = new CheckboxTreeViewer(layout, 2818);
        this.treeViewLaunches.setContentProvider((IContentProvider)new S32DebuggerGroupContentProvider());
        this.treeViewLaunches.setLabelProvider((IBaseLabelProvider)new S32DebuggerGroupLaunchLabelProvider());
        this.treeViewLaunches.setCheckStateProvider((ICheckStateProvider)new S32DebuggerGroupCheckStateProvider());
        Tree treeTable = this.treeViewLaunches.getTree();
        treeTable.setFont(parent.getFont());
        treeTable.setHeaderVisible(true);
        treeTable.setLayoutData((Object)new GridData(1808));
        TreeColumn colLeft = new TreeColumn(treeTable, 0);
        colLeft.setText(S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunchTabGroup_name);
        colLeft.setWidth(400);
        TreeColumn colCenter = new TreeColumn(treeTable, 0);
        colCenter.setText(S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunchTabGroup_mode);
        colCenter.setWidth(50);
        TreeColumn colRight = new TreeColumn(treeTable, 0);
        colRight.setText(S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunchTabGroup_action);
        colRight.setWidth(175);
        this.treeViewLaunches.setInput(this.singleLaunches);
        final S32DebuggerTabGroupButtonComposite buttons = new S32DebuggerTabGroupButtonComposite(layout, 0){

            @Override
            protected void addPressed() {
                S32DebuggerGroupLaunchConfigurationSelectionDialog dialog = new S32DebuggerGroupLaunchConfigurationSelectionDialog(S32DebuggerGroupLaunchTab.this.treeViewLaunches.getControl().getShell(), S32DebuggerGroupLaunchTab.this.mode, false);
                if (dialog.open() == 0) {
                    ILaunchConfiguration[] configurations = dialog.getSelectedLaunchConfigurations();
                    if (configurations.length == 0) {
                        return;
                    }
                    ILaunchConfiguration[] iLaunchConfigurationArray = configurations;
                    int n = configurations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                        S32DebuggerSingleLaunchElement element = new S32DebuggerSingleLaunchElement();
                        S32DebuggerGroupLaunchTab.this.singleLaunches.add(element);
                        element.setIndex(S32DebuggerGroupLaunchTab.this.singleLaunches.size() - 1);
                        element.setLaunchEnabled(true);
                        element.setLaunchName(config.getName());
                        element.setLCData(config);
                        element.setLaunchMode(dialog.getMode());
                        element.setActionAfterLaunch(dialog.getAction());
                        element.setLaunchActionData(dialog.getAfterActionData());
                        S32DebuggerGroupLaunchTab.this.treeViewLaunches.refresh(true);
                        S32DebuggerGroupLaunchTab.this.treeViewLaunches.setChecked((Object)element, element.isLaunchEnabled());
                        ++n2;
                    }
                    this.updateWidgetEnablement();
                    S32DebuggerGroupLaunchTab.this.updateLaunchConfigurationDialog();
                }
            }

            @Override
            protected void updateWidgetEnablement() {
                this.buttonDown.setEnabled(this.isDownEnabled());
                this.buttonUp.setEnabled(this.isUpEnabled());
                int selectedIndex = this.getSingleSelectionIndex();
                boolean editEnabled = this.getSelectionCount() == 1 && S32DebuggerGroupLaunchTab.this.singleLaunches.get(selectedIndex).getLCData() != null;
                this.buttonEdit.setEnabled(editEnabled);
                boolean removalEnabled = this.getSelectionCount() > 0;
                this.buttonRemove.setEnabled(removalEnabled);
            }

            @Override
            protected void editPressed() {
                int index = this.getSingleSelectionIndex();
                if (index < 0) {
                    return;
                }
                S32DebuggerSingleLaunchElement element = S32DebuggerGroupLaunchTab.this.singleLaunches.get(index);
                S32DebuggerGroupLaunchConfigurationSelectionDialog dialog = new S32DebuggerGroupLaunchConfigurationSelectionDialog(S32DebuggerGroupLaunchTab.this.treeViewLaunches.getControl().getShell(), element.getLaunchMode(), true);
                if (S32DebuggerGroupLaunchTab.isValidLaunchReference(element.getLCData())) {
                    dialog.setSelectionOnInit(element);
                }
                if (dialog.open() == 0) {
                    ILaunchConfiguration[] configurations = dialog.getSelectedLaunchConfigurations();
                    if (configurations.length == 0) {
                        return;
                    }
                    if (!$assertionsDisabled && configurations.length != 1) {
                        throw new AssertionError((Object)"Editing is allowed only for one selected configuration");
                    }
                    element.setLaunchName(configurations[0].getName());
                    element.setLCData(configurations[0]);
                    element.setLaunchMode(dialog.getMode());
                    element.setActionAfterLaunch(dialog.getAction());
                    element.setLaunchActionData(dialog.getAfterActionData());
                    S32DebuggerGroupLaunchTab.this.treeViewLaunches.refresh(true);
                    this.updateWidgetEnablement();
                    S32DebuggerGroupLaunchTab.this.updateLaunchConfigurationDialog();
                }
            }

            @Override
            protected void removePressed() {
                int[] indices = this.getMultiSelectionIndices();
                if (indices.length < 1) {
                    return;
                }
                int i = indices.length - 1;
                while (i >= 0) {
                    S32DebuggerGroupLaunchTab.this.singleLaunches.remove(indices[i]);
                    --i;
                }
                S32DebuggerGroupLaunchTab.this.treeViewLaunches.refresh(true);
                this.updateWidgetEnablement();
                S32DebuggerGroupLaunchTab.this.updateLaunchConfigurationDialog();
            }

            private int getSingleSelectionIndex() {
                StructuredSelection selection = (StructuredSelection)S32DebuggerGroupLaunchTab.this.treeViewLaunches.getSelection();
                if (selection.size() != 1) {
                    return -1;
                }
                S32DebuggerSingleLaunchElement element = (S32DebuggerSingleLaunchElement)selection.getFirstElement();
                return S32DebuggerGroupLaunchTab.this.singleLaunches.indexOf(element);
            }

            private int[] getMultiSelectionIndices() {
                StructuredSelection selection = (StructuredSelection)S32DebuggerGroupLaunchTab.this.treeViewLaunches.getSelection();
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (S32DebuggerSingleLaunchElement element : selection) {
                    indices.add(S32DebuggerGroupLaunchTab.this.singleLaunches.indexOf(element));
                }
                int[] result = new int[indices.size()];
                int i = 0;
                while (i < result.length) {
                    result[i] = (Integer)indices.get(i);
                    ++i;
                }
                return result;
            }

            private int getSelectionCount() {
                return ((StructuredSelection)S32DebuggerGroupLaunchTab.this.treeViewLaunches.getSelection()).size();
            }

            @Override
            protected void downPressed() {
                if (!this.isDownEnabled()) {
                    return;
                }
                int index = this.getSingleSelectionIndex();
                S32DebuggerSingleLaunchElement element = S32DebuggerGroupLaunchTab.this.singleLaunches.get(index);
                S32DebuggerGroupLaunchTab.this.singleLaunches.set(index, S32DebuggerGroupLaunchTab.this.singleLaunches.get(index + 1));
                S32DebuggerGroupLaunchTab.this.singleLaunches.set(index + 1, element);
                S32DebuggerGroupLaunchTab.this.treeViewLaunches.refresh(true);
                this.updateWidgetEnablement();
                S32DebuggerGroupLaunchTab.this.updateLaunchConfigurationDialog();
            }

            protected boolean isDownEnabled() {
                int index = this.getSingleSelectionIndex();
                return index >= 0 && index != S32DebuggerGroupLaunchTab.this.singleLaunches.size() - 1;
            }

            protected boolean isUpEnabled() {
                return this.getSingleSelectionIndex() > 0;
            }

            @Override
            protected void upPressed() {
                if (!this.isUpEnabled()) {
                    return;
                }
                int index = this.getSingleSelectionIndex();
                S32DebuggerSingleLaunchElement element = S32DebuggerGroupLaunchTab.this.singleLaunches.get(index);
                S32DebuggerGroupLaunchTab.this.singleLaunches.set(index, S32DebuggerGroupLaunchTab.this.singleLaunches.get(index - 1));
                S32DebuggerGroupLaunchTab.this.singleLaunches.set(index - 1, element);
                S32DebuggerGroupLaunchTab.this.treeViewLaunches.refresh(true);
                this.updateWidgetEnablement();
                S32DebuggerGroupLaunchTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.treeViewLaunches.getControl().addListener(1, event -> {
            if (event.keyCode == 127) {
                buttons.removePressed();
            }
        });
        this.treeViewLaunches.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                buttons.updateWidgetEnablement();
            }
        });
        this.treeViewLaunches.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                TreeItem item = (TreeItem)event.item;
                Object data = item.getData();
                if (data instanceof S32DebuggerSingleLaunchElement && ((S32DebuggerSingleLaunchElement)data).getLCData() != null) {
                    buttons.editPressed();
                }
            }
        });
        this.treeViewLaunches.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((S32DebuggerSingleLaunchElement)event.getElement()).setLaunchEnabled(event.getChecked());
                S32DebuggerGroupLaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
        buttons.updateWidgetEnablement();
        GridData layoutData = new GridData(1024);
        layoutData.verticalAlignment = 1;
        buttons.setLayoutData(layoutData);
    }

    public String getName() {
        return S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunchTabGroup_launches;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.singleLaunches = S32DebuggerSingleLaunchElement.createLaunchElements((ILaunchConfiguration)configuration, new ArrayList());
        if (this.treeViewLaunches != null) {
            this.treeViewLaunches.setInput(this.singleLaunches);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        S32DebuggerSingleLaunchElement.storeLaunchElements((ILaunchConfigurationWorkingCopy)configuration, this.singleLaunches);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setMessage(null);
        this.setErrorMessage(null);
        int validLaunches = 0;
        for (S32DebuggerSingleLaunchElement element : this.singleLaunches) {
            if (!element.isLaunchEnabled()) continue;
            if (element.getLCData() == null) {
                this.setErrorMessage(MessageFormat.format(S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunchTabGroup_no_launch, element.getLaunchName()));
                return false;
            }
            if (!S32DebuggerGroupLaunchTab.isValidLaunchReference(element.getLCData())) {
                this.setErrorMessage(MessageFormat.format(S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunchTabGroup_launch_is_filtered, element.getLaunchName()));
                return false;
            }
            ++validLaunches;
        }
        if (validLaunches < 1) {
            this.setErrorMessage(S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunchTabGroup_must_have_launch);
            return false;
        }
        return true;
    }

    public static boolean isValidLaunchReference(ILaunchConfiguration configuration) {
        return DebugUIPlugin.doLaunchConfigurationFiltering((ILaunchConfiguration)configuration) && !WorkbenchActivityHelper.filterItem((Object)configuration);
    }
}

