/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.core.cli.cmd;

import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import com.nxp.s32ds.rcp.license.core.cli.ISettings;
import com.nxp.s32ds.rcp.license.core.cli.cmd.ICommand;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractCommand
implements ICommand {
    private static final String PARAM_TS_PATH = "tspath";
    private static final String PARAM_PROXY = "proxy";
    private static final String PARAM_TEST_FNO = "testFNO";
    private Map<String, String> params = new HashMap<String, String>();
    private final ICLL cll;
    private final ISettings settings;
    private static final Pattern REGEXP_PROXY = Pattern.compile("(?<user>\\w*):(?<pass>\\w*)@(?<server>[A-Za-z0-9\\.]+):(?<port>\\d*)");

    public AbstractCommand(ICLL cll, ISettings settings) {
        this.cll = cll;
        this.settings = settings;
        this.getParams().put(PARAM_PROXY, "Setup proxy username:password@host:port format");
        this.getParams().put(PARAM_TEST_FNO, "Use test FNO. false by default, use: -testFNO true");
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public String getProblemDescription() {
        this.loadProxySettings();
        return null;
    }

    private void loadProxySettings() {
        if (this.settings.getParam(PARAM_PROXY) != null) {
            Matcher m = REGEXP_PROXY.matcher(this.settings.getParam(PARAM_PROXY));
            if (!m.find()) {
                System.err.println("proxy format error, skip.");
            } else {
                this.getSettings().setProxyUser(m.group("user"));
                this.getSettings().setProxyPassword(m.group("pass"));
                this.getSettings().setProxyHost(m.group("server"));
                this.getSettings().setProxyPort(Integer.parseInt(m.group("port")));
            }
        }
    }

    @Override
    public Map<String, String> getOneLineParamsDesc() {
        return this.params;
    }

    public void initLicenseLocation() throws Exception {
        if (!this.params.containsKey(PARAM_TS_PATH)) {
            return;
        }
        String tsPath = this.params.get(PARAM_TS_PATH);
        CLLReason reason = this.getCll().setLicenseLocation(tsPath, null, 0);
        if (reason != null) {
            throw new Exception(reason.toString());
        }
    }

    public ICLL getCll() {
        return this.cll;
    }

    public ISettings getSettings() {
        return this.settings;
    }

    public boolean isTestFNO() {
        return "true".equals(this.getSettings().getParam(PARAM_TEST_FNO));
    }

    public void setupProxy() {
        this.loadProxySettings();
        if (this.getSettings().getProxyHost() != null) {
            System.out.println("Using proxy " + this.getSettings().getProxyUser() + ":" + this.getSettings().getProxyPassword() + "@" + this.getSettings().getProxyHost() + ":" + this.getSettings().getProxyPort());
            this.getCll().configureProxy(this.getSettings().getProxyHost(), this.getSettings().getProxyPort(), this.getSettings().getProxyUser(), this.getSettings().getProxyPassword());
        }
    }
}

