/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.core.cli.cmd;

import com.nxp.s32ds.ext.rcp.license.cll.CLLFeatureDetail;
import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import com.nxp.s32ds.rcp.license.core.cli.ISettings;
import com.nxp.s32ds.rcp.license.core.cli.cmd.AbstractCommand;
import com.nxp.s32ds.rcp.license.core.cli.cmd.ActivateUI;
import com.nxp.s32ds.rcp.license.core.cli.cmd.ui.UIUtils;
import java.io.File;

public class InstallActivation
extends AbstractCommand {
    public InstallActivation(ICLL cll, ISettings settings) {
        super(cll, settings);
    }

    @Override
    public String getName() {
        return "run";
    }

    @Override
    public String getOneLineDesc() {
        return "run activateUI and verify (to use in installation)";
    }

    @Override
    public boolean canExecute() {
        return this.getProblemDescription() == null;
    }

    @Override
    public String getProblemDescription() {
        String rootProblems = super.getProblemDescription();
        if (rootProblems != null) {
            return rootProblems;
        }
        if (this.getSettings().getParam("prod") == null) {
            return "Product name missing";
        }
        if (this.getSettings().getParam("feature") == null) {
            return "Feature name missing";
        }
        if (this.getSettings().getParam("version") == null) {
            return "Feature version missing";
        }
        return null;
    }

    @Override
    public int execute() {
        super.setupProxy();
        this.getCll().setFNOUrlForTesting(this.isTestFNO());
        String actId = "";
        while (true) {
            String version;
            String name;
            if ((actId = InstallActivation.askActiId(actId)) == null) {
                System.err.println("No Software Activation Code was entered");
                return 1;
            }
            try {
                CLLReason reason = new CLLReason();
                CLLFeatureDetail feature = this.getCll().listActivatedFeatures(actId, reason);
                if (feature != null) {
                    String msg = String.format("Software Activation Code is already used on this station for %s.", String.valueOf(feature.getProductName()) + " " + feature.getFeatureName() + " " + feature.getFeatureVersion());
                    UIUtils.showMessageDialog("NXP Software Activation", msg);
                    System.err.println("Software Activation Code " + actId + "; " + msg);
                    continue;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (this.activate(actId) == 1) continue;
            CLLFeatureDetail newFeatures = this.getCll().listActivatedFeatures(actId, null);
            String prod = this.getSettings().getParam("prod");
            if (InstallActivation.isFeatureHere(prod, name = this.getSettings().getParam("feature"), version = this.getSettings().getParam("version"), newFeatures)) {
                return 42;
            }
            boolean returnFeature = UIUtils.showConfirmDialog("NXP Software Activation", "Your Software Activation Code is for another feature. Do you want to return it?");
            System.err.print(String.format("Software Activation Code %s is for %s but expected %s:%s:%s feature", actId, newFeatures, prod, name, version));
            if (!returnFeature || this.returnLicenseUI(actId) == 0) continue;
            System.err.print(String.format("Failed to return activation ID: %s", actId));
        }
    }

    private static String askActiId(String inital) {
        String actId;
        while ((actId = UIUtils.showInputDialog("Software Activation Code", inital)) != null && actId.isEmpty()) {
            UIUtils.showWarningDialog("Empty Software Activation Code", "Please input Software Activation Code.");
        }
        return actId;
    }

    private static boolean isFeatureHere(String prod, String name, String version, CLLFeatureDetail newFeatures) {
        if (newFeatures == null) {
            return false;
        }
        CLLFeatureDetail cur = newFeatures;
        while (cur != null) {
            if (cur.getFeatureName().equals(name) && cur.getFeatureVersion().equals(version) && cur.getProductName().equals(prod)) {
                return true;
            }
            cur = cur.getNext();
        }
        return false;
    }

    private int activate(String actId) {
        try {
            int type = UIUtils.requestType("Choose activation type");
            switch (type) {
                case 0: {
                    return ActivateUI.activateOnline(actId, this.getCll());
                }
                case 1: {
                    return ActivateUI.activateOffline(actId, this.getCll());
                }
            }
            System.out.println("Wrong (none?) activation type selected.");
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            UIUtils.showMessageDialog("NXP Software Activation", e.getMessage());
            return 1;
        }
    }

    private int returnLicenseUI(String actId) {
        try {
            int type = UIUtils.requestType("Choose deactivation type");
            switch (type) {
                case 0: {
                    return this.returnOnline(actId);
                }
                case 1: {
                    return this.returnOffline(actId);
                }
            }
            System.out.println("Wrong activation type selected (HOW??)");
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            UIUtils.showMessageDialog("NXP Software Activation", e.getMessage());
            return 1;
        }
    }

    public int returnOnline(String actId) {
        CLLReason result = this.getCll().returnLicense(actId, false, null);
        if (result == null) {
            return 0;
        }
        UIUtils.showMessageDialog("NXP Software Activation", result.getErrorString());
        System.err.println(result);
        return 1;
    }

    public int returnOffline(String actId) {
        File request = null;
        do {
            if ((request = UIUtils.chooseFile("Offline return request", "Save", new File("request.xml"))) != null) continue;
            System.out.println("Exit by user request (no file selected)");
            return 1;
        } while (request.exists() && !UIUtils.confirmOverwrite());
        CLLReason requestResult = this.getCll().returnLicense(actId, true, request.getAbsolutePath());
        if (requestResult != null) {
            UIUtils.showMessageDialog("NXP Software Activation", requestResult.getErrorString());
            return 1;
        }
        return 0;
    }
}

