/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.internal.core;

import com.nxp.s32ds.rcp.license.core.FNOId;
import com.nxp.s32ds.rcp.license.core.LicenseChangeRequest;
import com.nxp.s32ds.rcp.license.core.LicenseException;
import com.nxp.s32ds.rcp.license.core.LicenseFeature;
import com.nxp.s32ds.rcp.license.core.LicenseService;
import com.nxp.s32ds.rcp.license.internal.core.CLLBackend;
import com.nxp.s32ds.rcp.license.internal.core.LicenseBackend;

public class LicenseServiceImpl
implements LicenseService {
    private final LicenseBackend backend;

    public LicenseServiceImpl() {
        this.backend = new CLLBackend();
    }

    public LicenseServiceImpl(LicenseBackend backend) {
        this.backend = backend;
    }

    @Override
    public void activate(LicenseChangeRequest activationRequest) throws LicenseException {
        this.checkBackend();
        this.backend.activate(activationRequest.getActivationId(), activationRequest.getParams());
    }

    @Override
    public void returnLicense(LicenseChangeRequest returnRequest) throws LicenseException {
        this.checkBackend();
        this.backend.returnLicense(returnRequest.getActivationId(), returnRequest.getParams());
    }

    @Override
    public void refresh(String activationId) throws LicenseException {
        this.checkBackend();
        this.backend.refreshFeature(activationId);
    }

    @Override
    public LicenseFeature fetchLicenseFeature(FNOId id) throws LicenseException {
        this.checkBackend();
        return this.backend.createFeature(id);
    }

    @Override
    public boolean verifyLicenseAvailabilityByFeature(String featureName, String version) throws LicenseException {
        this.checkBackend();
        return this.backend.isLicenseAvailableByFeature(featureName, version);
    }

    private void checkBackend() throws LicenseException {
        if (this.backend == null) {
            throw new LicenseException("License system is not initialized successfully");
        }
        if (this.backend.getProblem() != null) {
            if (this.backend.getProblem().getMessage() != null) {
                throw new LicenseException(this.backend.getProblem().getMessage());
            }
            throw new LicenseException("License system is not initialized successfully");
        }
    }
}

