/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek;

import com.freescale.s32ds.debug.ka.dsf.DSFInterface;
import com.freescale.s32ds.debug.ka.osek.OsekPlugin;
import com.freescale.s32ds.debug.ka.osek.implementation.IntegerListHolder;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttribute;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttributeModel;
import com.freescale.s32ds.debug.ka.osek.implementation.TypeObject;
import com.freescale.s32ds.debug.ka.osek.parser.OrtiParser;
import com.freescale.s32ds.debug.ka.osek.parser.OrtiRepository;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;

public class OsekAwareAdapter {
    protected String m_debuggerID;
    protected String m_servantID;
    protected IRunControl.IExecutionDMContext m_context;
    protected OrtiParser parser;
    protected OrtiRepository m_ortiRepository;

    public OsekAwareAdapter(IRunControl.IExecutionDMContext context, String debugger, String servant) {
        this.m_debuggerID = debugger;
        this.m_servantID = servant;
        this.m_context = context;
        this.m_ortiRepository = new OrtiRepository();
        this.parser = new OrtiParser(context);
        String fname = this.getOrtiFileLocationFromLaunchConfiguration();
        this.parser.parseFile(fname, 1, this.m_ortiRepository);
    }

    private String getOrtiFileLocationFromLaunchConfiguration() {
        ILaunch[] launches;
        String path = "";
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] iLaunchArray = launches = launchManager.getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            try {
                if (!launch.isTerminated()) {
                    ILaunchConfiguration lConfig = launch.getLaunchConfiguration();
                    path = lConfig.getAttribute("com.freescale.s32ds.debug.ka.osplugin.ortifile", path);
                }
            }
            catch (CoreException e) {
                OsekPlugin.log(e);
            }
            ++n2;
        }
        return path;
    }

    public IRunControl.IExecutionDMContext getContext() {
        return this.m_context;
    }

    public String getDebugger() {
        return this.m_debuggerID;
    }

    public String getServantID() {
        return this.m_servantID;
    }

    public String GetOrtiVersionString() {
        if (this.parser != null && this.parser.parsedOK) {
            return String.format("KOIL ver. %s, Semantics \"%s\" ver. %s", this.m_ortiRepository.getKOILVersion(), this.m_ortiRepository.getSemanticsName(), this.m_ortiRepository.getSemanticsVersion());
        }
        return "";
    }

    public String GetImplementationName() {
        if (this.parser != null && this.parser.parsedOK) {
            return this.m_ortiRepository.getName();
        }
        return "";
    }

    public TypeObject[] GetObjectTree() {
        if (this.parser != null && this.parser.parsedOK) {
            return this.m_ortiRepository.getObjTree();
        }
        return null;
    }

    public OrtiImplObject GetImplObject(String typeName) {
        if (this.parser != null && this.parser.parsedOK) {
            return this.m_ortiRepository.getImplObject(typeName);
        }
        return null;
    }

    public OrtiObject[] GetOrtiObjects(String typeName) {
        if (this.parser != null && this.parser.parsedOK) {
            return this.m_ortiRepository.getOrtiObjects(typeName);
        }
        return null;
    }

    public boolean EvaluateAttributeList(int[] attrIDList, IntegerListHolder results, IntegerListHolder erroneousResultIDs) {
        if (attrIDList != null) {
            if (this.parser != null && this.parser.parsedOK) {
                int[] nArray = attrIDList;
                int n = attrIDList.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    OrtiObjectAttribute attr = this.m_ortiRepository.getAttrById(i);
                    if (attr == null) {
                        erroneousResultIDs.value.add(i);
                    } else if (attr.formula.length() > 0 && Character.isDigit(attr.formula.charAt(0))) {
                        Long lValue = attr.formula.startsWith("0x") ? Long.valueOf(Long.parseLong(attr.formula.substring(2), 16)) : Long.valueOf(Long.parseLong(attr.formula, 10));
                        results.value.add(lValue.intValue());
                    } else if (attr instanceof OrtiObjectAttributeModel) {
                        results.value.add(attr.getValue());
                    } else {
                        try {
                            results.value.add(DSFInterface.getDefault().iEvaluateExpression(this.m_context, attr.formula));
                        }
                        catch (NumberFormatException e) {
                            OsekPlugin.log(e);
                            return false;
                        }
                    }
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }

    public boolean SetTraceParams(int sessionID, int sampleTimeInterval, int traceSlots, int[] attrIDList) {
        return false;
    }

    public boolean GetAttributeTraceBuffer(int sessionID, int attrID, IntegerListHolder buffer, IntegerListHolder errors) {
        return false;
    }
}

