/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek;

import com.freescale.s32ds.debug.ka.osek.OsekAwareAdapter;
import com.freescale.s32ds.debug.ka.osek.OsekConsoleLogger;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiImplementationManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.launching.GDBProcess;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class OsekPlugin
extends AbstractUIPlugin
implements IDebugEventSetListener {
    private static final String PLUGIN_ID = "com.freescale.s32ds.debug.ka.osek";
    public Map<IRunControl.IExecutionDMContext, OsekAwareAdapter> fOsekAdapters = new HashMap<IRunControl.IExecutionDMContext, OsekAwareAdapter>();
    public OsekAwareAdapter fAdapter;
    private static OsekPlugin instance;
    private OsekConsoleLogger m_OsekLogConsole;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        instance = null;
        super.stop(context);
    }

    public static OsekPlugin getDefault() {
        return instance;
    }

    public synchronized OsekConsoleLogger getOsekLogConsole() {
        if (this.m_OsekLogConsole == null) {
            this.m_OsekLogConsole = new OsekConsoleLogger();
        }
        return this.m_OsekLogConsole;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static void log(IStatus status) {
        OsekPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        OsekPlugin.log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), e));
    }

    public OsekAwareAdapter getOsekAwareAdapter(IRunControl.IExecutionDMContext context) {
        if (this.fOsekAdapters.containsKey(context)) {
            this.fAdapter = this.fOsekAdapters.get(context);
            return this.fAdapter;
        }
        OsekAwareAdapter adapter = new OsekAwareAdapter(context, "debugger", "servid");
        this.fOsekAdapters.put(context, adapter);
        this.fAdapter = adapter;
        return this.fAdapter;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        Arrays.stream(events).forEach(event -> {
            switch (event.getKind()) {
                case 8: {
                    Object source = event.getSource();
                    if (!(source instanceof GDBProcess)) break;
                    GDBProcess process = (GDBProcess)source;
                    OrtiImplementationManager.getDefault().removeOrtiImpl(process.getLaunch());
                    break;
                }
            }
        });
    }
}

