/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.implementation;

import com.freescale.s32ds.debug.ka.dsf.DSFInterface;
import com.freescale.s32ds.debug.ka.osek.OsekPlugin;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttribute;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttributeModel;
import com.freescale.s32ds.debug.ka.osek.parser.OrtiRepository;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.debug.service.IRunControl;

public class OrtiObjectAttributeForPeak
extends OrtiObjectAttributeModel {
    private static final String BASEADDRESS = "BASEADDRESS";
    private static final String FILLPATTERN = "FILLPATTERN";
    private static final String SIZE = "SIZE";
    private static final String STACKDIRECTION = "STACKDIRECTION";

    public OrtiObjectAttributeForPeak(OrtiRepository repository, IRunControl.IExecutionDMContext context, OrtiObject ortiObject) {
        super(repository, context, ortiObject);
    }

    public OrtiObjectAttributeForPeak() {
    }

    @Override
    public int getValue() {
        OrtiObject ortiObject = this.ortiRepository.getObject(this.mOrtiObject.name);
        Integer baseaddress = null;
        Integer fillpattern = null;
        Integer size = null;
        Integer direction = null;
        for (OrtiObjectAttribute attr : ortiObject.attributes) {
            if (attr.implAttribute.name.equals(BASEADDRESS)) {
                baseaddress = attr.value;
                continue;
            }
            if (attr.implAttribute.name.equals(FILLPATTERN)) {
                fillpattern = attr.getValue();
                continue;
            }
            if (attr.implAttribute.name.equals(SIZE)) {
                size = attr.value;
                continue;
            }
            if (!attr.implAttribute.name.equals(STACKDIRECTION)) continue;
            direction = attr.value == 0 ? 1 : -1;
        }
        return this.getPeakStackUsage(baseaddress, fillpattern, size, direction);
    }

    private int getPeakStackUsage(Integer baseaddress, Integer fillpattern, Integer size, Integer direction) {
        int i;
        if (baseaddress == null || fillpattern == null || size == null || direction == null || size == 0) {
            this.erroneous = true;
            return 0;
        }
        String[] memory = null;
        try {
            memory = DSFInterface.getDefault().sGetMemory(this.mContext, (long)baseaddress.intValue(), size.intValue()).split(",");
        }
        catch (ExecutionException e) {
            OsekPlugin.log(e);
            this.erroneous = true;
            return 0;
        }
        if (memory == null || memory.length == 0 || memory[0].isEmpty()) {
            this.erroneous = true;
            return 0;
        }
        int n = i = direction == 1 ? 0 : memory.length - 1;
        if (i < 0 || i > memory.length - 1) {
            this.erroneous = true;
            return 0;
        }
        if (!memory[i].substring(2).equalsIgnoreCase(Integer.toHexString(fillpattern))) {
            fillpattern = Integer.reverseBytes(fillpattern);
        }
        while (direction == 1 && i < memory.length || direction != 1 && i >= 0) {
            if (!memory[i].substring(2).equalsIgnoreCase(Integer.toHexString(fillpattern))) break;
            i += direction.intValue();
        }
        int part = direction == 1 ? i : memory.length - i;
        return (int)(100.0 - (double)part / (double)memory.length * 100.0);
    }
}

