/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.parser;

import com.freescale.s32ds.debug.ka.osek.OsekPlugin;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplAttr;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplEnumAttr;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttribute;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttributeModel;
import com.freescale.s32ds.debug.ka.osek.parser.AbstractOrtiParser;
import com.freescale.s32ds.debug.ka.osek.parser.ILexemeAnalyzer;
import com.freescale.s32ds.debug.ka.osek.parser.IOrtiParser;
import com.freescale.s32ds.debug.ka.osek.parser.LexemAnalyzer;
import com.freescale.s32ds.debug.ka.osek.parser.OrtiRepository;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class OrtiParser
extends AbstractOrtiParser
implements ILexemeAnalyzer {
    LexemAnalyzer lex;
    int attrCount = 0;
    OrtiRepository m_ortiRepository;
    private HashMap<String, OrtiImplEnumAttr> m_enumWithLinkedObjectList = new HashMap();
    private String m_parseErrors;
    public boolean parsedOK = false;
    private IRunControl.IExecutionDMContext mContext;
    private Map<String, List<Map<String, Object>>> extensionCache = new HashMap<String, List<Map<String, Object>>>();
    private static final String SYSTEM_TAB_EXTENSION_ID = "com.freescale.system.browser.systemTabs";

    public IOrtiParser OP_CreateParser() {
        return new OrtiParser();
    }

    public OrtiParser() {
    }

    public OrtiParser(IRunControl.IExecutionDMContext context) {
        this.mContext = context;
    }

    private void syntaxError() {
        this.m_parseErrors = String.valueOf(this.m_parseErrors) + "ORTI parser error: line -" + Integer.toString(this.lex.getLineNumber());
    }

    private boolean loadFile(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        try {
            this.lex = new LexemAnalyzer(Files.readAllLines(path, StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            this.m_parseErrors = String.valueOf(this.m_parseErrors) + "Cannot read file - " + fileName + " Error reason :" + ex.getMessage();
            return false;
        }
        return true;
    }

    private boolean processKOILSection() {
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID, "VERSION") || !this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "{")) {
            return false;
        }
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID, "KOIL") || !this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "=")) {
            return false;
        }
        if (!(this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String) || this.lex.getStr().equalsIgnoreCase("2.2") && this.lex.getStr().equalsIgnoreCase("2.1"))) {
            return false;
        }
        this.m_ortiRepository.setKOILVersion(this.lex.getStr());
        return this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";");
    }

    private boolean processSemanticSection() {
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID, "OSSEMANTICS") || !this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "=")) {
            return false;
        }
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
            return false;
        }
        this.m_ortiRepository.setSemanticsName(this.lex.getStr());
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ",")) {
            return false;
        }
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
            return false;
        }
        this.m_ortiRepository.setSemanticsVersion(this.lex.getStr());
        return true;
    }

    private boolean processEndSection() {
        return this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";") && this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "}") && this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";");
    }

    private boolean processVersionSection() {
        boolean result = this.processKOILSection() && this.processSemanticSection() && this.processEndSection();
        return result;
    }

    private boolean processImplSection() {
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID, "IMPLEMENTATION")) {
            return false;
        }
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
            return false;
        }
        this.m_ortiRepository.setName(this.lex.getStr());
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "{")) {
            return false;
        }
        while (this.processImplObject()) {
        }
        return this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "}") && this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";");
    }

    private boolean processImplObject() {
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
            return false;
        }
        OrtiImplObject implObject = new OrtiImplObject();
        implObject.name = this.lex.getStr();
        if (this.m_ortiRepository.hasImplObject(implObject.name)) {
            return false;
        }
        this.m_ortiRepository.setImplObject(implObject.name, implObject);
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "{")) {
            return false;
        }
        while (this.processImplAttr(implObject)) {
        }
        if (!this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "}")) {
            return false;
        }
        if (this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ",")) {
            if (this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
                this.lex.getNext();
            } else {
                return false;
            }
        }
        return this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";");
    }

    /*
     * Unable to fully structure code
     */
    private boolean processImplAttr(OrtiImplObject implObject) {
        block16: {
            block17: {
                toTrace = false;
                noType = false;
                if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
                    return false;
                }
                if (this.lex.getStr().equalsIgnoreCase("TOTRACE")) {
                    toTrace = true;
                    if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
                        return false;
                    }
                }
                implAttr = new OrtiImplAttr(implObject, toTrace);
                if (!this.lex.getStr().equalsIgnoreCase("ENUM")) break block17;
                implAttr.type = 1;
                if (this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
                    implAttr.ctype = this.lex.getStr();
                    this.lex.getNext();
                } else {
                    implAttr.ctype = "Not defined";
                }
                if (this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "[")) ** GOTO lbl-1000
                return false;
                while (this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ",")) lbl-1000:
                // 2 sources

                {
                    if (this.processImplAttrEnumValue(implAttr)) continue;
                    break block16;
                }
                break block16;
            }
            if (this.lex.getStr().equalsIgnoreCase("CTYPE")) {
                implAttr.type = 2;
                if (this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
                    implAttr.ctype = this.lex.getStr();
                } else {
                    implAttr.ctype = "Not defined";
                    noType = true;
                }
            } else if (this.lex.getStr().equalsIgnoreCase("STRING")) {
                implAttr.type = 3;
            }
        }
        if (!noType && !this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
            return false;
        }
        implAttr.name = this.lex.getStr();
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol)) {
            return false;
        }
        if (this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ",")) {
            if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
                return false;
            }
            implAttr.description = this.lex.getStr();
            this.lex.getNext();
        }
        if (!this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";")) {
            return false;
        }
        implObject.attributesList.put(implAttr.name, implAttr);
        return true;
    }

    private boolean processImplAttrEnumValue(OrtiImplAttr ImplAttr) {
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
            return false;
        }
        OrtiImplEnumAttr enumValue = new OrtiImplEnumAttr(this.mContext);
        ImplAttr.enumList.add(enumValue);
        enumValue.desc = this.lex.getStr();
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol)) {
            return false;
        }
        if (this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ":")) {
            if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
                return false;
            }
            enumValue.linkedName = this.lex.getStr();
            this.m_enumWithLinkedObjectList.put(this.lex.getStr(), enumValue);
            this.lex.getNext();
        }
        if (!this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "=")) {
            return false;
        }
        this.lex.getNext();
        switch (this.lex.m_type) {
            case OP_String: 
            case OP_IntegerConstant: {
                break;
            }
            default: {
                return false;
            }
        }
        enumValue.mFormula = this.lex.getStr();
        return true;
    }

    private boolean processObject() {
        OrtiObject ortiObject;
        OrtiImplObject implObject;
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
            return false;
        }
        String impName = this.lex.getStr();
        if (this.m_ortiRepository.hasImplObject(impName)) {
            implObject = this.m_ortiRepository.getImplObject(impName);
            if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
                return false;
            }
            ortiObject = new OrtiObject();
            ortiObject.name = this.lex.getStr();
            if (this.m_ortiRepository.hasObject(ortiObject.name)) {
                return false;
            }
            if (this.m_enumWithLinkedObjectList.containsKey(ortiObject.name)) {
                this.m_enumWithLinkedObjectList.get((Object)ortiObject.name).linkedObject = ortiObject;
                this.m_enumWithLinkedObjectList.remove(ortiObject.name);
            }
            ortiObject.m_implObject = implObject;
            if (implObject.typeObjectList.type == null) {
                implObject.typeObjectList.type = impName;
            }
            implObject.typeObjectList.instances.add(ortiObject.name);
            this.m_ortiRepository.setObject(ortiObject.name, ortiObject);
            if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "{")) {
                return false;
            }
        } else {
            return false;
        }
        while (this.processAttr(ortiObject)) {
        }
        this.addAditionalAttributes(impName, ortiObject, implObject);
        return this.lex.Cmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "}") && this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";");
    }

    private void addAditionalAttributes(String impName, OrtiObject ortiObject, OrtiImplObject implObject) {
        for (Map.Entry<String, List<Map<String, Object>>> entry : this.extensionCache.entrySet()) {
            if (!entry.getKey().equals(impName)) continue;
            for (Map<String, Object> tabs : entry.getValue()) {
                IConfigurationElement element = (IConfigurationElement)tabs.get("IConfigurationElement");
                if (element == null) continue;
                OrtiObjectAttributeModel attr = null;
                try {
                    attr = (OrtiObjectAttributeModel)element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    OsekPlugin.log(e);
                    continue;
                }
                if (attr == null) continue;
                attr.setmContext(this.mContext);
                attr.setmOrtiObject(ortiObject);
                attr.setOrtiRepository(this.m_ortiRepository);
                this.createAttribute(ortiObject, implObject, tabs, attr);
            }
        }
    }

    private OrtiImplAttr createAttribute(OrtiObject ortiObject, OrtiImplObject implObject, Map<String, Object> tabs, OrtiObjectAttribute attr) {
        if (attr == null) {
            return null;
        }
        attr.attrID = this.attrCount++;
        attr.isStatic = Boolean.valueOf((String)tabs.get("static"));
        attr.formula = (String)tabs.get("formula");
        this.m_ortiRepository.addAttrList(attr);
        OrtiImplAttr implattr = new OrtiImplAttr(implObject, Boolean.valueOf((String)tabs.get("traced")));
        implattr.type = tabs.get("type").equals("C Type") ? 2 : 3;
        implattr.name = (String)tabs.get("label");
        implattr.ctype = tabs.get("type").equals("C Type") ? (String)tabs.get("cType") : "";
        implattr.description = (String)tabs.get("description");
        ortiObject.m_implObject.attributesList.put((String)tabs.get("dataID"), implattr);
        attr.implAttribute = implattr;
        ortiObject.attributes.add(attr);
        return implattr;
    }

    private boolean processAttr(OrtiObject ortiObject) {
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_ID)) {
            return false;
        }
        String impAttrName = this.lex.getStr();
        if (ortiObject.m_implObject.attributesList.containsKey(impAttrName)) {
            if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, "=")) {
                return false;
            }
            if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_String)) {
                return false;
            }
            OrtiObjectAttribute ortiObjAttr = new OrtiObjectAttribute();
            ortiObjAttr.formula = this.lex.getStr();
            ortiObjAttr.attrID = this.attrCount;
            if (ortiObject.m_implObject.attributesList.get((Object)impAttrName).type == 3) {
                ortiObjAttr.isStatic = true;
            }
            if (ortiObjAttr.formula.length() > 0 && Character.isDigit(ortiObjAttr.formula.charAt(0))) {
                ortiObjAttr.isStatic = true;
                Long lValue = ortiObjAttr.formula.startsWith("0x") ? Long.valueOf(Long.parseLong(ortiObjAttr.formula.substring(2), 16)) : Long.valueOf(Long.parseLong(ortiObjAttr.formula, 10));
                ortiObjAttr.value = lValue.intValue();
            }
            ++this.attrCount;
            this.m_ortiRepository.addAttrList(ortiObjAttr);
            ortiObjAttr.implAttribute = ortiObject.m_implObject.attributesList.get(impAttrName);
            ortiObject.attributes.add(ortiObjAttr);
            return this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_Symbol, ";");
        }
        return false;
    }

    private void getAdditionalColumn() {
        IConfigurationElement[] element;
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(SYSTEM_TAB_EXTENSION_ID);
        IConfigurationElement[] ces = ep.getConfigurationElements();
        Optional<IConfigurationElement> config = Arrays.stream(ces).filter(c -> c.getNamespaceIdentifier().equals(OsekPlugin.getPluginId())).findAny();
        if (config.isEmpty()) {
            return;
        }
        Optional<IConfigurationElement> configChild = Arrays.stream(config.get().getChildren()).filter(c -> c.getName().equals("systemTabTasks")).findAny();
        if (configChild.isEmpty()) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = element = (IConfigurationElement[])Arrays.stream(configChild.get().getChildren()).filter(c -> c.getName().equals("systemTabColumn")).toArray(IConfigurationElement[]::new);
        int n = element.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement sys = iConfigurationElementArray[n2];
            HashMap<String, String> map = new HashMap<String, String>();
            String[] stringArray = sys.getAttributeNames();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray[n4];
                map.put(name, sys.getAttribute(name));
                ++n4;
            }
            map.put("IConfigurationElement", (String)sys);
            this.extensionCache.computeIfAbsent(sys.getAttribute("tabId"), e -> new ArrayList()).add(map);
            ++n2;
        }
    }

    public boolean parseFile(String fName, int limitObjects, OrtiRepository rep) {
        this.m_parseErrors = "Starting.. \n";
        this.m_ortiRepository = rep;
        if (!this.loadFile(fName)) {
            return false;
        }
        if (!this.processVersionSection()) {
            this.syntaxError();
            return false;
        }
        if (!this.processImplSection()) {
            this.syntaxError();
            return false;
        }
        this.getAdditionalColumn();
        while (this.processObject()) {
        }
        if (!this.lex.getNextCmp(ILexemeAnalyzer.OP_LexemeType.OP_EOF)) {
            this.syntaxError();
            return false;
        }
        this.m_parseErrors = String.valueOf(this.m_parseErrors) + "Parse OK.. \n";
        this.parsedOK = true;
        return true;
    }

    @Override
    public String getErrors() {
        return this.m_parseErrors;
    }

    @Override
    public boolean parseFile(String fName, int limitObjects) {
        return false;
    }
}

