/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.utils;

import com.freescale.s32ds.debug.ka.osek.OsekPlugin;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OrtiImageResources {
    private static Map<ImageType, Image> fResMap = new EnumMap<ImageType, Image>(ImageType.class);

    public static Image GetImage(ImageType type) {
        Image img = fResMap.get((Object)type);
        if (img == null) {
            switch (type.bundle) {
                case Local: {
                    try {
                        img = AbstractUIPlugin.imageDescriptorFromPlugin((String)OsekPlugin.getPluginId(), (String)("icons/" + type.fileName)).createImage();
                    }
                    catch (Exception exc) {
                        OsekPlugin.log(exc);
                        img = null;
                    }
                    break;
                }
                case CdtUI: {
                    img = CPluginImages.get((String)type.fileName);
                    break;
                }
                case DebugPluginUI: {
                    img = DebugPluginImages.getImage((String)type.fileName);
                }
            }
            if (img != null) {
                fResMap.put(type, img);
            }
        }
        return img;
    }

    private static enum ImageBundles {
        Local,
        DebugPluginUI,
        CdtUI;

    }

    public static enum ImageType {
        OsekLogo(ImageBundles.Local, "oseklogo.png"),
        Error(ImageBundles.CdtUI, "org.eclipse.cdt.ui.error_obj.gif"),
        Warning(ImageBundles.CdtUI, "org.eclipse.cdt.ui.warning_obj.gif"),
        OrtiImplObject(ImageBundles.CdtUI, "org.eclipse.cdt.ui.class_obj.gif"),
        VSOrtiImplObject(ImageBundles.CdtUI, "org.eclipse.cdt.ui.typedef_obj.gif"),
        OrtiObject(ImageBundles.CdtUI, "org.eclipse.cdt.ui.variable_obj.gif"),
        OrtiAttribute(ImageBundles.CdtUI, "org.eclipse.cdt.ui.field_public_obj.gif"),
        OrtiEnum(ImageBundles.CdtUI, "org.eclipse.cdt.ui.enum_obj.gif"),
        OrtiString(ImageBundles.CdtUI, "org.eclipse.cdt.ui.struct_obj.gif"),
        OrtiCtype(ImageBundles.CdtUI, "org.eclipse.cdt.ui.classfo_obj.gif"),
        TracedAttr(ImageBundles.CdtUI, "org.eclipse.cdt.ui.exec_dbg_obj.gif"),
        EnterSection(ImageBundles.DebugPluginUI, "IMG_ELCL_STEP_INTO"),
        ExitSection(ImageBundles.DebugPluginUI, "IMG_ELCL_STEP_RETURN");

        public String fileName;
        public ImageBundles bundle;

        private ImageType(ImageBundles bundle, String file) {
            this.bundle = bundle;
            this.fileName = file;
        }
    }
}

