/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.controller;

import com.nxp.freertos.gdb.tad.ReadingException;
import com.nxp.freertos.gdb.tad.controller.TadFactoryData;
import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOS;
import com.nxp.freertos.gdb.tad.model.readers.MemoryReader;
import com.nxp.freertos.gdb.tad.model.readers.VariableReader;
import com.nxp.freertos.gdb.tad.model.views.TadValue;
import com.nxp.freertos.gdb.tad.strings.Texts;
import java.util.List;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.debug.core.DebugException;

public abstract class TadFactory {
    public static final int VARIABLE_NOT_EXISTS = -1;
    private MemoryReader memoryReader;
    private VariableReader variableReader;
    protected FreeRTOS freeRTOS;

    public TadFactory(MemoryReader memoryReader, VariableReader variableReader, FreeRTOS freeRTOS) {
        this.memoryReader = memoryReader;
        this.variableReader = variableReader;
        this.freeRTOS = freeRTOS;
    }

    public abstract TadFactoryData getData();

    public synchronized void setContext(IRunControl.IExecutionDMContext context) {
        this.variableReader.setContext(context);
        this.memoryReader.setContext(context);
    }

    public synchronized long getStructSize(String structName) throws ReadingException {
        String text = this.variableReader.getStructSize(structName);
        if (TadFactory.isTextValid(text)) {
            try {
                return Long.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("%s", structName));
    }

    public synchronized long getSize(String name) throws ReadingException {
        String text = this.variableReader.getSize(name);
        if (TadFactory.isTextValid(text)) {
            try {
                return Long.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("%s", name));
    }

    public synchronized long readAddressAtAddress(long address, String structName, String memberName) throws ReadingException {
        String text = this.variableReader.getAddressAtAddress(address, structName, memberName);
        if (TadFactory.isTextValid(text)) {
            try {
                return Long.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("0x%08x, %s, %s", address, structName, memberName));
    }

    public synchronized long readLongAtAddress(long address, String structName, String memberName) throws ReadingException {
        String text = this.variableReader.getValueAtAddress(address, structName, memberName, false);
        if (TadFactory.isTextValid(text)) {
            try {
                return Long.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("0x%08x, %s, %s", address, structName, memberName));
    }

    public synchronized TadValue readLongAndContextAtAddress(long address, String structName, String memberName) throws ReadingException {
        String text = this.variableReader.getValueAtAddress(address, structName, memberName, true);
        if (TadFactory.isTextValid(text)) {
            return new TadValue(text);
        }
        throw new ReadingException(String.format("0x%08x, %s, %s", address, structName, memberName));
    }

    public synchronized String readTextAtAddress(long address) throws ReadingException {
        StringBuilder builder = new StringBuilder();
        for (int c : this.readMemoryUntilZero(address)) {
            builder.append((char)c);
        }
        return builder.toString();
    }

    public synchronized int readIntAtAddress(long address, String structName, String memberName) throws ReadingException {
        String text = this.variableReader.getValueAtAddress(address, structName, memberName, false);
        if (TadFactory.isTextValid(text)) {
            try {
                return Integer.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("0x%08x, %s, %s", address, structName, memberName));
    }

    public synchronized long readAddressOfVariable(String name) throws ReadingException {
        String text = this.variableReader.getAddressOfVariable(name);
        if (TadFactory.isTextValid(text)) {
            try {
                return Long.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("%s", name));
    }

    public synchronized long readLongVariable(String name) throws ReadingException {
        String text = this.variableReader.getVariable(name);
        if (TadFactory.isTextValid(text)) {
            try {
                return Long.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("%s", name));
    }

    public synchronized int readIntVariable(String name) throws ReadingException {
        String text = this.variableReader.getVariable(name);
        if (TadFactory.isTextValid(text)) {
            try {
                return Integer.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("%s", name));
    }

    private synchronized long getOffset(String structName, String memberName) throws ReadingException {
        String text = this.variableReader.getOffset(structName, memberName);
        if (TadFactory.isTextValid(text)) {
            try {
                return Long.decode(text);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new ReadingException(String.format("%s, %s", structName, memberName));
    }

    public synchronized String readTaskName(long address) throws ReadingException {
        if (address > 0L) {
            long nameOffset = this.getOffset(this.freeRTOS.getStruct("task_control_block"), "pcTaskName");
            return this.readTextAtAddress(address + nameOffset);
        }
        return Texts.get("Error.Unknown");
    }

    public synchronized List<Integer> readMemoryBlock(long address, long length) throws ReadingException {
        try {
            return this.memoryReader.getMemoryBlock(address, length);
        }
        catch (DebugException debugException) {
            throw new ReadingException(String.format("0x%08x, %d", address, length));
        }
    }

    public synchronized List<Long> readMemoryBlock(long address, long length, int bytes) throws ReadingException {
        try {
            return this.memoryReader.getMemoryBlock(address, length, bytes);
        }
        catch (DebugException debugException) {
            throw new ReadingException(String.format("0x%08x, %d, 0x%x", address, length, bytes));
        }
    }

    private synchronized List<Integer> readMemoryUntilZero(long address) throws ReadingException {
        try {
            return this.memoryReader.readMemoryUntilZero(address);
        }
        catch (DebugException debugException) {
            throw new ReadingException(String.format("0x%08x", address));
        }
    }

    public static boolean isTextValid(String text) {
        return text != null && text.trim().length() != 0;
    }

    public synchronized int readIntVariableSafely(String name) {
        try {
            return this.readIntVariable(name);
        }
        catch (ReadingException readingException) {
            Logger.error(String.format(Texts.get("Error.ReadSafely"), "readIntVariableSafely", name));
            return -1;
        }
    }

    public synchronized long readLongVariableSafely(String name) {
        try {
            return this.readLongVariable(name);
        }
        catch (ReadingException readingException) {
            Logger.error(String.format(Texts.get("Error.ReadSafely"), "readLongVariableSafely", name));
            return -1L;
        }
    }

    public synchronized long readAddressOfVariableSafely(String name) {
        try {
            return this.readAddressOfVariable(name);
        }
        catch (ReadingException readingException) {
            Logger.error(String.format(Texts.get("Error.ReadSafely"), "readAddressOfVariableSafely", name));
            return -1L;
        }
    }

    public synchronized int readIntAtAddressSafely(long address, String structName, String memberName) throws ReadingException {
        try {
            return this.readIntAtAddress(address, structName, memberName);
        }
        catch (ReadingException readingException) {
            Logger.error(String.format(Texts.get("Error.ReadSafely"), "readIntAtAddressSafely", String.format("0x%08x, %s.%s", address, structName, memberName)));
            return -1;
        }
    }

    public synchronized long readLongAtAddressSafely(long address, String structName, String memberName) {
        try {
            return this.readLongAtAddress(address, structName, memberName);
        }
        catch (ReadingException readingException) {
            Logger.error(String.format(Texts.get("Error.ReadSafely"), "readLongAtAddressSafely", String.format("0x%08x, %s.%s", address, structName, memberName)));
            return -1L;
        }
    }
}

