/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.views.tasklist;

import com.nxp.freertos.gdb.tad.Activator;
import com.nxp.freertos.gdb.tad.model.Auxiliary;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOSConfig;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskStack;
import com.nxp.freertos.gdb.tad.model.views.tasklist.TaskType;
import com.nxp.freertos.gdb.tad.view.TadView;
import com.nxp.freertos.gdb.tad.view.TadViewType;
import com.nxp.freertos.gdb.tad.view.column.TadColumn;
import com.nxp.freertos.gdb.tad.view.column.TadColumnCopyable;
import com.nxp.freertos.gdb.tad.view.column.TadColumnId;
import com.nxp.freertos.gdb.tad.view.column.TadColumnWeight;
import com.nxp.freertos.gdb.tad.view.providers.TadBarGraphProvider;
import com.nxp.freertos.gdb.tad.view.views.tasklist.TaskItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;

public class TaskListView
extends TadView {
    public TaskListView() {
        super(TadViewType.SINGLE);
        this.parentColumns.add(new TadColumn(TadColumnId.ID, "TCB#", "Task number (user or TCB)", TadColumnWeight.SMALL, TadColumnCopyable.READ_ONLY, null, FreeRTOSConfig.USE_TRACE));
        this.parentColumns.add(new TadColumn(TadColumnId.NAME, "Task Name", "Text name assigned to task", TadColumnWeight.WIDE, TadColumnCopyable.COPYABLE));
        this.parentColumns.add(new TadColumn(TadColumnId.ADDRESS, "Task Handle", "Task handle address", TadColumnWeight.NORMAL, TadColumnCopyable.COPYABLE));
        this.parentColumns.add(new TadColumn(TadColumnId.STATE, "Task State", "Current task state", TadColumnWeight.NORMAL, TadColumnCopyable.COPYABLE));
        this.parentColumns.add(new TadColumn(TadColumnId.PRIORITY, "Priority", "Current task priority (Actual / Base)", TadColumnWeight.SMALL, TadColumnCopyable.COPYABLE));
        this.parentColumns.add(new TadColumn(TadColumnId.USAGE_GRAPH, "Stack Usage", "Stack High Water Mark / Stack Size", TadColumnWeight.WIDE, TadColumnCopyable.COPYABLE, new TadBarGraphProvider(){

            protected void paint(Event event, Object element) {
                TaskItem taskItem;
                if (element != null && element instanceof TaskItem && (taskItem = (TaskItem)element).getTask() != null) {
                    TaskStack stack = taskItem.getTask().getStack();
                    super.paintBarGraph(event, Auxiliary.getPercentage(stack.getUsage(), stack.getSize()), taskItem.getText(TadColumnId.USAGE_GRAPH), (Color)(taskItem.getTask().getType() == TaskType.RTOS ? Auxiliary.LIGHT_GREEN_COLOUR : null), !Activator.getTadModel().getFreeRTOS().isMacroEnabled(FreeRTOSConfig.RECORD_STACK_HIGH_ADDRESS));
                }
            }
        }, FreeRTOSConfig.RECORD_STACK_HIGH_ADDRESS));
        this.parentColumns.add(new TadColumn(TadColumnId.EVENT_OBJ, "Event Object", "The name (or address) of queue on which is task blocked", TadColumnWeight.WIDE, TadColumnCopyable.COPYABLE));
        this.parentColumns.add(new TadColumn(TadColumnId.RUNTIME, "Runtime", "Task active time in percent of total runtime", TadColumnWeight.NORMAL, TadColumnCopyable.COPYABLE, new TadBarGraphProvider(){

            protected void paint(Event event, Object element) {
                TaskItem taskItem;
                if (element != null && element instanceof TaskItem && (taskItem = (TaskItem)element).getTask() != null) {
                    super.paintBarGraph(event, Auxiliary.getPercentage(taskItem.getTask().getTaskRuntime(), taskItem.getTask().getRuntime()), taskItem.getText(TadColumnId.RUNTIME), Auxiliary.LIGHT_GREEN_COLOUR, taskItem.isParent() && this.dependency != null && taskItem.getText(this.columnId) == null);
                }
            }
        }, FreeRTOSConfig.RUNTIME_STATS));
    }

    @Override
    protected TadView getTadView() {
        return this;
    }

    public String getTitle() {
        return "Task List";
    }
}

