/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.DivCommonSlave;
import com.nxp.swtools.clocks.model.Divider;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.List;

public class DivCommonRatioList
extends DivCommonSlave {
    @Nullable
    protected List<@NonNull BigRational> allowedRatios = null;

    protected DivCommonRatioList(@NonNull String id, @NonNull TimingScale scaler) {
        super(id, scaler);
    }

    protected DivCommonRatioList(@NonNull String id, @NonNull TimingScale scaler, @NonNull BigRational defaultScale) {
        super(id, scaler, defaultScale);
    }

    @Override
    boolean checkScaleRatio(@NonNull BigRational ratioToMaster, @NonNull Divider masterArg) {
        FreqLimitErrorI locLogFLE = this.logFLE;
        if (this.allowedRatios != null) {
            if (this.allowedRatios.contains(ratioToMaster)) {
                return true;
            }
            if (locLogFLE != null && this.enabled) {
                locLogFLE.logDividerError(EDividerError.MasterSlaveRatioInSlave, this);
                locLogFLE.logDividerError(EDividerError.MasterSlaveRatioInMaster, masterArg);
            }
            return false;
        }
        if (ratioToMaster.getDenominator().equals(TimingScale.ONE)) {
            BigInteger maximalRatioLoc = this.maximalRatio;
            if (maximalRatioLoc == null) {
                return true;
            }
            BigInteger ratio = ratioToMaster.getNumerator();
            if (ratio.compareTo(maximalRatioLoc) <= 0) {
                return true;
            }
            if (locLogFLE != null && this.enabled) {
                locLogFLE.logDividerError(EDividerError.MasterSlaveRatioInSlave, this);
                locLogFLE.logDividerError(EDividerError.MasterSlaveRatioInMaster, masterArg);
            }
            return false;
        }
        if (locLogFLE != null && this.enabled) {
            locLogFLE.logDividerError(EDividerError.RatioNotIntegralInSlave, this);
            locLogFLE.logDividerError(EDividerError.RatioNotIntegralInMaster, masterArg);
        }
        return false;
    }

    @Override
    EErrorType testScaleRatio(@NonNull BigRational ratioToMaster) {
        List<@NonNull BigRational> locAllowedRatios = this.allowedRatios;
        if (locAllowedRatios != null) {
            if (!locAllowedRatios.contains(ratioToMaster)) {
                if (ratioToMaster.compareTo(locAllowedRatios.get(0)) < 0) {
                    return EErrorType.TooFast;
                }
                if (ratioToMaster.compareTo(locAllowedRatios.get(locAllowedRatios.size() - 1)) > 0) {
                    return EErrorType.TooSlow;
                }
                return EErrorType.CannotSetup;
            }
        } else {
            BigInteger ratio;
            if (!ratioToMaster.getDenominator().equals(TimingScale.ONE)) {
                return EErrorType.CannotSetup;
            }
            BigInteger maximalRatioLoc = this.maximalRatio;
            if (maximalRatioLoc != null && (ratio = ratioToMaster.getNumerator()).compareTo(maximalRatioLoc) > 0) {
                return EErrorType.TooFast;
            }
        }
        return EErrorType.None;
    }

    @Override
    public void setMaximalRatio(@Nullable BigInteger maxRatio) {
        this.maximalRatio = maxRatio;
        this.allowedRatios = null;
    }

    @Override
    public void setAllowedRatios(@NonNull List<@NonNull BigRational> ratios) {
        this.maximalRatio = null;
        this.allowedRatios = ratios;
    }
}

