/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.DivCommonRatioList;
import com.nxp.swtools.clocks.model.Divider;
import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DivSlave
extends DivCommonRatioList {
    @NonNull
    private Divider master;
    private boolean locked;
    @NonNull
    private @NonNull List<@NonNull Divider> masters = new ArrayList<Divider>(1);

    public DivSlave(@NonNull String id, @NonNull TimingScale scaler) {
        super(id, scaler);
        this.type = ENodeType.DivSlave;
        this.master = DUMMY_DIVIDER;
        this.locked = false;
    }

    public DivSlave(@NonNull String id, @NonNull TimingScale scaler, @NonNull BigRational defaultScale) {
        super(id, scaler, defaultScale);
        this.type = ENodeType.DivSlave;
        this.master = DUMMY_DIVIDER;
        this.locked = false;
    }

    @Override
    public void setMaster(@NonNull Divider master) {
        this.master = master;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean setOutputFrequency(byte freq) {
        BigRational tmpFreq = new BigRational(freq);
        return this.setOutputFrequency(tmpFreq);
    }

    @Override
    public boolean setOutputFrequency(short freq) {
        BigRational tmpFreq = new BigRational(freq);
        return this.setOutputFrequency(tmpFreq);
    }

    @Override
    public boolean setOutputFrequency(int freq) {
        BigRational tmpFreq = new BigRational(freq);
        return this.setOutputFrequency(tmpFreq);
    }

    @Override
    public boolean setOutputFrequency(long freq) {
        BigRational tmpFreq = new BigRational(freq);
        return this.setOutputFrequency(tmpFreq);
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigInteger freq) {
        BigRational tmpFreq = new BigRational(freq);
        return this.setOutputFrequency(tmpFreq);
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigRational freq) {
        if (this.locked) {
            return false;
        }
        return super.setOutputFrequency(freq);
    }

    @Override
    public boolean setScale(@Nullable BigRational newScale) {
        if (this.locked) {
            return false;
        }
        BigRational curScale = null;
        FreqLimitErrorI locLogFLE = this.logFLE;
        if (newScale == null || this.scaler == null) {
            this.setScale = null;
            if (this.useDefaults) {
                curScale = this.defaultScale;
            }
        } else if (this.scaler.elem(newScale)) {
            curScale = this.setScale = newScale;
        } else {
            this.setScale = null;
        }
        if (curScale == null && newScale != null) {
            if (locLogFLE != null && this.enabled) {
                locLogFLE.logDividerError(EDividerError.ScaleOutOfRange, this);
            }
            return false;
        }
        if (curScale != null && this.master != DUMMY_DIVIDER) {
            if (this.master.setScale != null) {
                return this.checkScaleRatio(curScale.divide(this.master.setScale), this.master);
            }
            if (this.master.useDefaults && this.master.defaultScale != null) {
                return this.checkScaleRatio(curScale.divide(this.master.defaultScale), this.master);
            }
        }
        return true;
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        EErrorType sbr;
        assert (this.master != DUMMY_DIVIDER) : "Master divider not set in " + this.id;
        if (callee != this.master) {
            return EErrorType.None;
        }
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        this.wasComputed = true;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        if ((sbr = this.testInputFreq(clock)) != EErrorType.None) {
            return sbr;
        }
        assert (this.scaler != null) : "Null scaler in divider " + this.id;
        assert (this.child != null) : "Null child in divider " + this.id;
        this.inputClock = clock;
        this.compScale = null;
        BigRational xxCompScale = this.getActualScale();
        BigRational masterCompScale = this.master.getActualScale();
        assert (masterCompScale != null) : "Not defined master division scale";
        if (xxCompScale != null) {
            return this.computeWith2Scales(clock, xxCompScale, masterCompScale);
        }
        BigRational xxSetOutputFreq = this.setOutputFreq;
        if (xxSetOutputFreq != null) {
            return this.computeWithFreqScale(clock, xxSetOutputFreq, masterCompScale);
        }
        BigRational xxDefaultScale = this.defaultScale;
        if (xxDefaultScale != null && xxDefaultScale.compareTo(this.scaler.from) != 0) {
            return this.computeAutoWithDefaultAll(clock, masterCompScale);
        }
        return this.goThroughAll(clock, masterCompScale);
    }

    @Override
    public @Nullable Divider getMasterDivider() {
        if (this.master == DUMMY_DIVIDER) {
            return null;
        }
        return this.master;
    }

    @Override
    public @NonNull List<@NonNull Divider> getMasters() {
        if (this.masters.size() < 1) {
            this.masters.add(0, this.master);
        } else {
            this.masters.set(0, this.master);
        }
        List<@NonNull Divider> result = Collections.unmodifiableList(this.masters);
        assert (result != null);
        return result;
    }

    private @NonNull EErrorType goThroughAll(@NonNull BigRational clock, @NonNull BigRational masterCompScale) {
        EErrorType res = EErrorType.TooFast;
        boolean fst = true;
        EErrorType outres = EErrorType.None;
        block5: for (BigRational scale : this.scaler) {
            assert (scale != null);
            @NonNull EErrorType scaleRes = this.testScaleRatio(scale.divide(masterCompScale));
            if (scaleRes != EErrorType.None) {
                switch (scaleRes) {
                    case TooFast: {
                        continue block5;
                    }
                    case TooSlow: {
                        if (outres == EErrorType.None) {
                            return EErrorType.TooSlow;
                        }
                        return EErrorType.CannotSetup;
                    }
                    case CannotSetup: {
                        if (outres != EErrorType.None) continue block5;
                        outres = EErrorType.CannotSetup;
                        continue block5;
                    }
                    default: {
                        return scaleRes;
                    }
                }
            }
            @NonNull BigRational xxCompScale = scale;
            BigRational newClock = clock.divide(xxCompScale);
            EErrorType sbr = this.testOutputFreq(newClock);
            if (sbr != EErrorType.None) {
                if (outres != EErrorType.CannotSetup || sbr == EErrorType.TooFast) {
                    outres = sbr == EErrorType.TooFast ? sbr : (outres == EErrorType.TooFast ? EErrorType.CannotSetup : sbr);
                }
                if (sbr != EErrorType.TooSlow) continue;
                return outres;
            }
            this.outputClock = newClock;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, newClock);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale;
                return EErrorType.None;
            }
            if (nres == EErrorType.BothFastSlow) {
                return nres;
            }
            if (nres == EErrorType.TooSlow) {
                if (fst) {
                    return EErrorType.TooSlow;
                }
                return EErrorType.CannotSetup;
            }
            fst = false;
            if (nres == EErrorType.TooFast && res == nres) continue;
            res = EErrorType.CannotSetup;
        }
        if (outres == EErrorType.CannotSetup) {
            res = outres;
        }
        return res;
    }

    private @NonNull EErrorType computeAutoWithDefaultAll(@NonNull BigRational clock, @NonNull BigRational masterCompScale) {
        BigRational xxCompScale = this.defaultScale;
        assert (xxCompScale != null);
        @NonNull BigRational newClock = BigRational.ZERO;
        @NonNull EErrorType sbr = EErrorType.None;
        if (this.computeWith2Scales(clock, xxCompScale, masterCompScale) == EErrorType.None) {
            return EErrorType.None;
        }
        boolean startSlower = false;
        @NonNull BigRational startScale = this.scaler.from;
        if (sbr == EErrorType.TooFast) {
            startScale = xxCompScale;
            startSlower = true;
        }
        EErrorType res = EErrorType.TooFast;
        boolean fst = true;
        EErrorType outres = EErrorType.None;
        block5: for (BigRational scale : this.scaler) {
            assert (scale != null);
            if (startSlower && scale.compareTo(startScale) <= 0) continue;
            @NonNull EErrorType scaleRes = this.testScaleRatio(scale.divide(masterCompScale));
            if (scaleRes != EErrorType.None) {
                switch (scaleRes) {
                    case TooFast: {
                        continue block5;
                    }
                    case TooSlow: {
                        if (outres == EErrorType.None) {
                            return EErrorType.TooSlow;
                        }
                        return EErrorType.CannotSetup;
                    }
                    case CannotSetup: {
                        if (outres != EErrorType.None) continue block5;
                        outres = EErrorType.CannotSetup;
                        continue block5;
                    }
                    default: {
                        return scaleRes;
                    }
                }
            }
            xxCompScale = scale;
            newClock = clock.divide(xxCompScale);
            sbr = this.testOutputFreq(newClock);
            if (sbr != EErrorType.None) {
                if (outres != EErrorType.CannotSetup || sbr == EErrorType.TooFast) {
                    outres = sbr == EErrorType.TooFast ? sbr : (outres == EErrorType.TooFast ? EErrorType.CannotSetup : sbr);
                }
                if (sbr != EErrorType.TooSlow) continue;
                return outres;
            }
            this.outputClock = newClock;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, newClock);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale;
                return EErrorType.None;
            }
            if (nres == EErrorType.BothFastSlow) {
                return nres;
            }
            if (nres == EErrorType.TooSlow) {
                if (fst) {
                    return EErrorType.TooSlow;
                }
                return EErrorType.CannotSetup;
            }
            fst = false;
            if (nres == EErrorType.TooFast && res == nres) continue;
            res = EErrorType.CannotSetup;
        }
        if (outres == EErrorType.CannotSetup) {
            res = outres;
        }
        return res;
    }
}

