/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.PLL;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.util.logging.Logger;

@NonNullByDefault
public class PLLrev
extends PLL {
    private static final Logger LOGGER = LogManager.getLogger(PLLrev.class);
    protected BigRational postDividerVal = BigRational.ONE;
    private TimingScale postDivider;

    public PLLrev(String id, TimingScale multiplier, TimingScale divider, TimingScale postDivider) {
        super(id, multiplier, divider);
        this.type = ENodeType.PLLrev;
        this.postDivider = postDivider;
    }

    @Override
    public void setPostDivider(BigRational postDividerValue) {
        if (postDividerValue.compareTo(BigRational.ZERO) > 0) {
            LOGGER.severe("Incorrect value of postdivider, it must be positive!");
        }
        this.postDividerVal = postDividerValue;
    }

    @Override
    public BigRational getPostDivider() {
        return this.postDividerVal;
    }

    @Override
    public void setJustMultiplier(@Nullable BigRational multiply) {
        FreqLimitErrorI logger = this.logFLE;
        this.setMultiplier = null;
        this.setDivider = null;
        if (this.multiplier == null) {
            if (logger != null && this.enabled) {
                logger.logDividerError(EDividerError.ScaleOutOfRange, this);
            }
            return;
        }
        if (this.multiplier.elem(multiply)) {
            this.setMultiplier = multiply;
        } else if (multiply != null && logger != null && this.enabled) {
            this.isInternalDivError = false;
            logger.logDividerError(EDividerError.ScaleOutOfRange, this);
        }
    }

    @Override
    public boolean compute(Node callee, BigRational clock) {
        BigRational outputFreq;
        BigRational multiplierValue;
        if (!this.enabled) {
            return true;
        }
        assert (this.multiplier != null) : "PLL multiplier not defined - " + this.id;
        assert (this.divider != null) : "PLL multiplier not defined - " + this.id;
        if (!this.called) {
            LOGGER.warning("Node " + this.id + " called 2nd times, now from " + callee.id);
        }
        this.called = true;
        this.wasComputed = true;
        boolean res = true;
        this.inputClock = clock;
        if (!this.checkInputFreq(this.inputClock)) {
            res = false;
        }
        if ((multiplierValue = this.setMultiplier) != null) {
            BigRational dividerValue = this.setDivider;
            assert (dividerValue != null) : "Divider unset for PLL even if defined";
            outputFreq = clock.multiply(multiplierValue);
            BigRational internaleFreq = outputFreq.multiply(this.postDividerVal);
            if (!this.checkInternalDividerFreq(internaleFreq)) {
                res = false;
            }
        } else {
            assert (this.useDefaults) : "Default vaule used even if forbidden in " + this.id;
            BigRational locDefaultMul = this.defaultMul;
            assert (locDefaultMul != null) : "Default vaule used even if forbidden in " + this.id;
            BigRational locDefaultDiv = this.defaultDiv;
            assert (locDefaultDiv != null) : "Divider without default value and used for division";
            outputFreq = clock.multiply(locDefaultMul);
            BigRational internalFreq = outputFreq.multiply(this.postDividerVal);
            if (!this.checkInternalDividerFreq(internalFreq)) {
                res = false;
            }
        }
        if (!this.checkOutputFreq(outputFreq)) {
            res = false;
        }
        this.outputClock = outputFreq;
        if (this.child.compute(this, outputFreq)) {
            return res;
        }
        return false;
    }

    private EErrorType computeSetOutputFreq(BigRational clock, BigRational setOutFreq) {
        BigRational ratioio = setOutFreq.divide(clock);
        TimingScale locPostDivider = this.postDivider;
        TimingScale locMultiplier = this.multiplier;
        assert (locPostDivider != null);
        assert (locMultiplier != null);
        BigRational proposedMultiplier = locMultiplier.closest(ratioio);
        BigRational proposedOutput = clock.multiply(proposedMultiplier);
        BigRational proposedPostDivider = null;
        EErrorType result = EErrorType.None;
        for (BigRational postDividerFactor : locPostDivider) {
            assert (postDividerFactor != null);
            BigRational internalFreq = proposedOutput.multiply(postDividerFactor);
            EErrorType internalError = this.testDividerFreq(internalFreq);
            if (internalError == EErrorType.None) {
                proposedPostDivider = postDividerFactor;
                result = EErrorType.None;
                break;
            }
            if (result == EErrorType.None) {
                result = internalError;
                continue;
            }
            if (internalError == result) continue;
            result = EErrorType.CannotSetup;
        }
        if (proposedPostDivider == null) {
            return result;
        }
        this.postDividerVal = proposedPostDivider;
        this.compMultiplier = proposedMultiplier;
        BigRational ac = setOutFreq.compareTo(proposedOutput) < 0 ? proposedOutput.divide(setOutFreq).subtract(BigRational.ONE) : setOutFreq.divide(proposedOutput).subtract(BigRational.ONE);
        if (ac.compareTo(this.accuracy) > 0) {
            return EErrorType.CannotSetup;
        }
        EErrorType outputError = this.testOutputFreq(proposedOutput);
        if (outputError != EErrorType.None) {
            return outputError;
        }
        this.outputClock = proposedOutput;
        return EErrorType.None;
    }

    private EErrorType computePLLrevAllPos(BigRational clock) {
        TimingScale locPostDivider = this.postDivider;
        TimingScale locMultiplier = this.multiplier;
        assert (locPostDivider != null && locMultiplier != null);
        EErrorType outError = EErrorType.None;
        block0: for (BigRational mul : locMultiplier) {
            assert (mul != null);
            BigRational proposedOutput = clock.multiply(mul);
            outError = this.testOutputFreq(proposedOutput);
            if (outError == EErrorType.TooSlow) continue;
            if (outError == EErrorType.TooFast) break;
            for (BigRational postDividerFactor : locPostDivider) {
                assert (postDividerFactor != null);
                BigRational internalFreq = proposedOutput.multiply(postDividerFactor);
                EErrorType internalError = this.testDividerFreq(internalFreq);
                if (internalError == EErrorType.TooSlow) continue;
                if (internalError == EErrorType.TooFast) continue block0;
                this.lastComp = ECompState.OnceSatisfied;
                EErrorType childError = this.child.computeAutoWR(this, proposedOutput);
                if (childError == EErrorType.None || childError == EErrorType.NotEnabled) {
                    this.compMultiplier = mul;
                    this.postDividerVal = postDividerFactor;
                    this.outputClock = proposedOutput;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    return EErrorType.None;
                }
                if (childError == EErrorType.TooSlow || childError == EErrorType.CannotSetup) continue block0;
                return childError;
            }
        }
        if (outError == EErrorType.TooSlow) {
            return outError;
        }
        return EErrorType.CannotSetup;
    }

    private EErrorType computePLLrevAutoWR(BigRational clock) {
        BigRational actDiv;
        BigRational actMul;
        if (this.setMultiplier != null) {
            actMul = this.setMultiplier;
            actDiv = this.setDivider;
        } else if (this.useDefaults && this.defaultMul != null) {
            actMul = this.defaultMul;
            assert (this.defaultDiv != null) : "If default multiplier is set then divider must be set too in " + this.id;
            actDiv = this.defaultDiv;
        } else {
            actMul = null;
            actDiv = null;
        }
        BigRational setOutput = this.setOutputFreq;
        if (actMul != null && actDiv == null) {
            TimingScale locPostDivider = this.postDivider;
            assert (locPostDivider != null);
            BigRational proposedOutput = clock.multiply(actMul);
            EErrorType internalError = EErrorType.None;
            for (BigRational postDividerRatio : locPostDivider) {
                assert (postDividerRatio != null);
                BigRational internalFreq = proposedOutput.multiply(postDividerRatio);
                internalError = this.testDividerFreq(internalFreq);
                if (internalError == EErrorType.TooSlow) continue;
                if (internalError == EErrorType.TooFast) break;
                this.lastComp = ECompState.OnceSatisfied;
                EErrorType childError = this.child.computeAutoWR(this, proposedOutput);
                if (childError == EErrorType.None || childError == EErrorType.NotEnabled) {
                    this.compMultiplier = actMul;
                    this.postDividerVal = postDividerRatio;
                    this.outputClock = proposedOutput;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    return EErrorType.None;
                }
                return childError;
            }
            if (internalError == EErrorType.TooSlow) {
                return internalError;
            }
            return EErrorType.CannotSetup;
        }
        if (actMul != null) {
            BigRational proposedOutput = clock.multiply(actMul);
            BigRational internalFreq = proposedOutput.multiply(this.postDividerVal);
            EErrorType internalError = this.testDividerFreq(internalFreq);
            if (internalError != EErrorType.None) {
                return internalError;
            }
            internalError = this.testOutputFreq(proposedOutput);
            if (internalError != EErrorType.None) {
                return internalError;
            }
            this.outputClock = proposedOutput;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType childError = this.child.computeAutoWR(this, proposedOutput);
            if (childError == EErrorType.None || childError == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
            return childError;
        }
        if (setOutput != null) {
            EErrorType compResult = this.computeSetOutputFreq(clock, setOutput);
            BigRational locOutputClock = this.outputClock;
            assert (locOutputClock != null);
            if (compResult != EErrorType.None) {
                return compResult;
            }
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType childError = this.child.computeAutoWR(this, locOutputClock);
            if (childError == EErrorType.None || childError == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
            return childError;
        }
        return this.computePLLrevAllPos(clock);
    }

    @Override
    public EErrorType computeAutoWR(Node callee, BigRational clock) {
        BigRational proposedOutput;
        BigRational internalFreq;
        EErrorType internalError;
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        this.wasComputed = true;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        assert (this.multiplier != null) : "PLLrev not fully defined - " + this.id;
        EErrorType inputError = this.testInputFreq(clock);
        if (inputError != EErrorType.None) {
            return inputError;
        }
        this.inputClock = clock;
        BigRational locDefaultDiv = this.defaultDiv;
        BigRational locDefaultMul = this.defaultMul;
        if (locDefaultDiv != null && locDefaultMul != null && (internalError = this.testDividerFreq(internalFreq = (proposedOutput = clock.multiply(locDefaultMul)).multiply(this.postDividerVal))) == EErrorType.None && (internalError = this.testOutputFreq(proposedOutput)) == EErrorType.None) {
            this.outputClock = proposedOutput;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType childError = this.child.computeAutoWR(this, proposedOutput);
            if (childError == EErrorType.None || childError == EErrorType.NotEnabled) {
                this.compDivider = locDefaultDiv;
                this.compMultiplier = locDefaultMul;
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
        }
        return this.computePLLrevAutoWR(clock);
    }
}

