/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.resource.processors;

import com.nxp.s32ds.cle.ide.internal.sdk.core.IdeSdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.core.resource.processors.AbstractSdkResourceProcessor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkCore;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class LinkSdkResourceProcessor
extends AbstractSdkResourceProcessor {
    public LinkSdkResourceProcessor(SdkDescriptor sdk, boolean isBackupFiles) {
        this.sdk = sdk;
        this.isBackupFiles = isBackupFiles;
    }

    @Override
    public void touchFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            folder.create(8192, true, null);
        }
    }

    @Override
    public void touchFile(IFile file, IPath path, boolean isOverride) throws CoreException {
        IPath sdkRootPath;
        if (file.exists() && isOverride) {
            if (this.isBackupFiles) {
                this.createPRJBackupFile(file);
            } else {
                file.delete(true, null);
            }
        }
        if (!file.exists() && (sdkRootPath = EnvironmentSdkCore.getResolvedSdkPath((String)this.sdk.getId())) != null) {
            IPath relativePath = path.makeRelativeTo(sdkRootPath);
            if (!path.equals((Object)relativePath)) {
                relativePath = sdkRootPath.append(relativePath);
            }
            try {
                file.createLink(relativePath, 256, null);
            }
            catch (NullPointerException nullPointerException) {
                IdeSdkCoreActivator.getInstance().logInfo("NPE caught for createLink " + relativePath);
            }
        }
    }

    @Override
    public void touchFile(IFile file, IPath path) throws CoreException, IOException {
        this.touchFile(file, path, false);
    }
}

