/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.utils;

import com.nxp.s32ds.cle.ide.internal.sdk.core.ProjectSdkDescriptorImplementation;
import com.nxp.s32ds.cle.ide.sdk.core.ProjectSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.buildstep.BuildStepSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.environment.EnvironmentSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.lang.LangSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.module.ModuleSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.symbol.SymbolSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.toolchain.ToolChainSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.buildstep.BuildStepSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.buildstep.BuildStepSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.HardwareSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.lang.LangSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.platform.PlatformSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.symbol.SymbolSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.lang.LangSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.module.ModuleSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SdkDescriptorsRegitsrationUtils {
    private SdkDescriptorsRegitsrationUtils() {
    }

    public static IStatus registerSdkDescriptors(String sourceXml, SdkType sdkType, String projectName) {
        Element root = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayInputStream bais = new ByteArrayInputStream(sourceXml.getBytes(StandardCharsets.UTF_8));){
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                root = parser.parse(bais).getDocumentElement();
                if (root != null && "sdks".equals(root.getNodeName())) {
                    SdkDescriptorsRegitsrationUtils.getElements("sdk", root).forEach(sdkElement -> {
                        IStatus iStatus = SdkDescriptorsRegitsrationUtils.registerSdkDescriptors(sdkElement, sdkType, projectName);
                    });
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            IStatus status = SdkRegistryCoreActivator.getInstance().createError(NLS.bind((String)"Unable register SDK descriptors due to error: {0}", (Object)e.getMessage()));
            SdkRegistryCoreActivator.getInstance().log(status);
            return status;
        }
        return Status.OK_STATUS;
    }

    public static IStatus registerSdkDescriptors(String sourceXml, SdkType sdkType) {
        return SdkDescriptorsRegitsrationUtils.registerSdkDescriptors(sourceXml, sdkType, null);
    }

    public static IStatus registerSdkDescriptors(Element sdkElement, SdkType sdkType) {
        return SdkDescriptorsRegitsrationUtils.registerSdkDescriptors(sdkElement, sdkType, null);
    }

    public static IStatus registerSdkDescriptors(Element sdkElement, SdkType sdkType, String projectName) {
        SdkDescriptorImplementation sdkDescriptor = new SdkDescriptorImplementation(sdkElement, sdkType);
        SdkDescriptors.addSdkDescriptor((SdkDescriptor)sdkDescriptor);
        String sdkId = sdkDescriptor.getId();
        SdkDescriptorsRegitsrationUtils.registerLang(sdkElement, sdkId);
        SdkDescriptorsRegitsrationUtils.registerHardware(sdkElement, sdkId);
        SdkDescriptorsRegitsrationUtils.registerEnvironment(sdkElement, sdkId);
        SdkDescriptorsRegitsrationUtils.registerToolChains(sdkElement, sdkId);
        SdkDescriptorsRegitsrationUtils.registerPlatform(sdkElement, sdkId);
        SdkDescriptorsRegitsrationUtils.registerModules(sdkElement, sdkId);
        SdkDescriptorsRegitsrationUtils.registerBuildSteps(sdkElement, sdkId);
        if (projectName != null) {
            ProjectSdkDescriptors.addProjectSdkDescriptor(new ProjectSdkDescriptorImplementation(sdkElement, projectName));
        }
        return Status.OK_STATUS;
    }

    public static void unregisterSdkDescriptors(String sdkId) {
        if (SdkDescriptors.getSdkDescriptor((String)sdkId) != null) {
            SdkDescriptors.removeSdkDescriptor((String)sdkId);
        }
        if (!LangSdkDescriptors.getLangSdkDescriptorsBySdkId((String)sdkId).isEmpty()) {
            LangSdkDescriptors.removeLangSdkDescriptors((String)sdkId);
        }
        HardwareSdkDescriptors.removeHardwareSdkDescriptors((String)sdkId);
        if (!ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId((String)sdkId).isEmpty()) {
            ResourceSdkDescriptors.removeResourceSdkDescriptors((String)sdkId);
        }
        if (!ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId((String)sdkId).isEmpty()) {
            ToolChainSdkDescriptors.removeToolChainSdkDescriptors((String)sdkId);
        }
        if (!EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorsBySdkId((String)sdkId).isEmpty()) {
            EnvironmentSdkDescriptors.removeEnvironmentSdkDescriptors((String)sdkId);
        }
        if (!SymbolSdkDescriptors.getSymbolSdkDescriptorsBySdkId((String)sdkId).isEmpty()) {
            SymbolSdkDescriptors.removeSymbolSdkDescriptors((String)sdkId);
        }
        PlatformSdkDescriptors.removePlatformSdkDescriptors((String)sdkId);
        if (!ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)sdkId).isEmpty()) {
            ModuleSdkDescriptors.removeModuleSdkDescriptors((String)sdkId);
        }
        if (!ProjectSdkDescriptors.getProjectSdkDescriptorsBySdkId(sdkId).isEmpty()) {
            ProjectSdkDescriptors.removeProjectSdkDescriptors(sdkId);
        }
    }

    private static void registerLang(Element sdkElement, String sdkId) {
        if (sdkElement.getAttribute("id").isEmpty() && sdkId != null && !sdkId.isEmpty()) {
            sdkElement.setAttribute("id", sdkId);
        }
        if (!sdkElement.getAttribute("id").isEmpty()) {
            LangSdkDescriptors.addLangSdkDescriptor((LangSdkDescriptor)new LangSdkDescriptorImplementation(sdkElement));
        }
    }

    private static void registerHardware(Element sdkElement, String sdkId) {
        if (sdkElement.getAttribute("id").isEmpty() && sdkId != null && !sdkId.isEmpty()) {
            sdkElement.setAttribute("id", sdkId);
        }
        if (!sdkElement.getAttribute("id").isEmpty()) {
            HardwareSdkDescriptors.addHardwareSdkDescriptors((Element)sdkElement);
        }
    }

    private static void registerEnvironment(Element sdkElement, String sdkId) {
        List<Element> environmentElements = SdkDescriptorsRegitsrationUtils.getElements("env", sdkElement);
        if (!environmentElements.isEmpty()) {
            EnvironmentSdkDescriptors.addEnvironmentSdkDescriptor((EnvironmentSdkDescriptor)new EnvironmentSdkDescriptorImplementation(environmentElements.get(0), sdkId));
        }
    }

    private static void registerActions(Element holderElement, String sdkId, String toolChainId) {
    }

    private static void registerToolChains(Element sdkElement, String sdkId) {
        Document document = sdkElement.getOwnerDocument();
        String toolChainsAttributeValue = sdkElement.getAttribute("toolchains");
        Set rootToolChainsIds = Arrays.stream(toolChainsAttributeValue.split(",")).map(String::trim).collect(Collectors.toSet());
        for (String rootToolChainId : rootToolChainsIds) {
            Element rootToolChainElement = document.createElement("toolchain");
            rootToolChainElement.setAttribute("id", rootToolChainId);
            ToolChainSdkDescriptorImplementation toolChainDescriptor = new ToolChainSdkDescriptorImplementation(rootToolChainElement, sdkId, true);
            ToolChainSdkDescriptors.addToolChainSdkDescriptor((ToolChainSdkDescriptor)toolChainDescriptor);
            SdkDescriptorsRegitsrationUtils.registerToolChainComponentsDescriptors(rootToolChainId, sdkElement, sdkId);
        }
        NodeList toolChainNodes = sdkElement.getElementsByTagName("toolchain");
        int i = 0;
        while (i < toolChainNodes.getLength()) {
            Node toolChainNode = toolChainNodes.item(i);
            if (sdkElement.equals(toolChainNode.getParentNode())) {
                Element toolChainElement = (Element)toolChainNode;
                String toolChainId = toolChainElement.getAttribute("id");
                ToolChainSdkDescriptorImplementation toolChainDescriptor = new ToolChainSdkDescriptorImplementation(toolChainElement, sdkId);
                ToolChainSdkDescriptors.addToolChainSdkDescriptor((ToolChainSdkDescriptor)toolChainDescriptor);
                SdkDescriptorsRegitsrationUtils.registerToolChainComponentsDescriptors(toolChainId, toolChainElement, sdkId);
            }
            ++i;
        }
    }

    private static void registerToolChainComponentsDescriptors(String toolChainId, Element holderElement, String sdkId) {
        SdkDescriptorsRegitsrationUtils.registerConditions(holderElement, sdkId, toolChainId);
        SdkDescriptorsRegitsrationUtils.registerActions(holderElement, sdkId, toolChainId);
        SdkDescriptorsRegitsrationUtils.registerSymbols(holderElement, sdkId, toolChainId);
        SdkDescriptorsRegitsrationUtils.registerResources(holderElement, sdkId, toolChainId);
    }

    private static void registerResources(Element holderElement, String sdkId, String toolChainId) {
        SdkDescriptor sdkDescriptor = SdkDescriptors.getSdkDescriptor((String)sdkId);
        if (sdkDescriptor != null) {
            String sdkBasePath = sdkDescriptor.getBasePath();
            Arrays.stream(ResourceSdkKind.values()).map(ResourceSdkKind::getXmlElementName).flatMap(name -> SdkDescriptorsRegitsrationUtils.getResourceElements(name, holderElement, sdkBasePath).stream()).forEach(element -> ResourceSdkDescriptors.addResourceSdkDescriptor((Element)element, (String)sdkId, (String)toolChainId));
        }
    }

    private static List<Element> getResourceElements(String name, Element holderElement, String sdkBasePath) {
        ArrayList<Element> elements = new ArrayList<Element>();
        IStringVariableManager svm = VariablesPlugin.getDefault().getStringVariableManager();
        for (Element element : SdkDescriptorsRegitsrationUtils.getElements(name, holderElement)) {
            try {
                String path = element.getAttribute("path").trim();
                if (path.isEmpty()) continue;
                if (!Paths.get(path, new String[0]).isAbsolute()) {
                    path = Paths.get(sdkBasePath, path).toString();
                }
                String substitutedPath = Path.fromOSString((String)svm.performStringSubstitution(path)).makeAbsolute().toOSString();
                element.setAttribute("path", substitutedPath);
                elements.add(element);
            }
            catch (InvalidPathException | CoreException e) {
                SdkRegistryCoreActivator.getInstance().logError(NLS.bind((String)"Unable register resource SDK descriptor due to error: {0}", (Object)e.getMessage()));
            }
        }
        return elements;
    }

    private static void registerSymbols(Element holderElement, String sdkId, String toolChainId) {
        SdkDescriptorsRegitsrationUtils.getElements("symbols", "symbol", holderElement).forEach(element -> SymbolSdkDescriptors.addSymbolSdkDescriptor((SymbolSdkDescriptor)new SymbolSdkDescriptorImplementation(element, sdkId, toolChainId)));
    }

    private static void registerConditions(Element holderElement, String sdkId, String toolChainId) {
    }

    private static void registerBuildSteps(Element sdkElement, String sdkId) {
        SdkDescriptorsRegitsrationUtils.getElements("buildSteps", "preBuildStep", sdkElement).forEach(element -> BuildStepSdkDescriptors.addBuildStepSdkDescriptor((BuildStepSdkDescriptor)new BuildStepSdkDescriptorImplementation(element, sdkId)));
        SdkDescriptorsRegitsrationUtils.getElements("buildSteps", "postBuildStep", sdkElement).forEach(element -> BuildStepSdkDescriptors.addBuildStepSdkDescriptor((BuildStepSdkDescriptor)new BuildStepSdkDescriptorImplementation(element, sdkId)));
    }

    private static void registerPlatform(Element sdkElement, String sdkId) {
        SdkDescriptorsRegitsrationUtils.getElements("platform", sdkElement).forEach(element -> PlatformSdkDescriptors.addPlatformSdkDescriptors((Element)element, (String)sdkId));
    }

    private static void registerModules(Element sdkElement, String sdkId) {
        SdkDescriptorsRegitsrationUtils.getElements("modules", "module", sdkElement).forEach(element -> ModuleSdkDescriptors.addModuleSdkDescriptor((ModuleSdkDescriptor)new ModuleSdkDescriptorImplementation(element, sdkId)));
    }

    private static List<Element> getElements(String groupElementName, String itemElementName, Element holderElement) {
        Element groupElement;
        NodeList groupNodes = holderElement.getElementsByTagName(groupElementName);
        if (groupNodes.getLength() > 0 && holderElement.equals((groupElement = (Element)groupNodes.item(0)).getParentNode())) {
            ArrayList<Element> elements = new ArrayList<Element>();
            NodeList itemNodes = groupElement.getElementsByTagName(itemElementName);
            int i = 0;
            while (i < itemNodes.getLength()) {
                elements.add((Element)itemNodes.item(i));
                ++i;
            }
            return elements;
        }
        return Collections.emptyList();
    }

    private static List<Element> getElements(String itemElementName, Element holderElement) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList itemNodes = holderElement.getElementsByTagName(itemElementName);
        int i = 0;
        while (i < itemNodes.getLength()) {
            Element itemElement = (Element)itemNodes.item(i);
            if (holderElement.equals(itemElement.getParentNode())) {
                elements.add((Element)itemNodes.item(i));
            }
            ++i;
        }
        return elements;
    }

    private Map<Element, List<Element>> getElementsMap(String groupElementName, String itemElementName, Element holderElement) {
        Element groupElement;
        NodeList groupNodes = holderElement.getElementsByTagName(groupElementName);
        if (groupNodes.getLength() > 0 && holderElement.equals((groupElement = (Element)groupNodes.item(0)).getParentNode())) {
            ArrayList<Element> itemElements = new ArrayList<Element>();
            NodeList itemNodes = groupElement.getElementsByTagName(itemElementName);
            int i = 0;
            while (i < itemNodes.getLength()) {
                itemElements.add((Element)itemNodes.item(i));
                ++i;
            }
            return Collections.singletonMap(groupElement, itemElements);
        }
        return Collections.emptyMap();
    }
}

