/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core.usb.devices.s32debugger.tap;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.debug.ide.core.internal.usb.devices.s32debugger.tap.S32DebuggerTapUsbDeviceAccessor;
import java.util.Collection;
import java.util.stream.Collectors;

public class S32DebuggerTapUsbDevices {
    private static String TEST_CONNECTION_NAME = "S32 Debug Probe - USB";
    private static final S32DebuggerTapUsbDeviceAccessor ACCESSOR = new S32DebuggerTapUsbDeviceAccessor();
    private static final DebuggerConnectionDescriptor DESCRIPTOR = new DebuggerConnectionDescriptor(){

        public boolean supportsDebuggerId(String debuggerId) {
            return "s32debugger".equals(debuggerId) || "s32debuggerflashprogrammer".equals(debuggerId);
        }

        public boolean isEthernetConnection() {
            return false;
        }

        public int getPriority() {
            return -1;
        }

        public String getConnectionName() {
            return TEST_CONNECTION_NAME;
        }

        public String getConnectionDescription() {
            return "";
        }
    };

    public static Collection<String> getConnectedUSBDevicesFW106() {
        return ACCESSOR.getActiveFW106DeviceConnections(DESCRIPTOR).stream().map(connection -> connection.getDeviceUiFriendlyName()).collect(Collectors.toSet());
    }

    public static String updateUSBDeviceFW106(String deviceFriendlyName) {
        return ACCESSOR.runFirmwareUpdate(deviceFriendlyName);
    }
}

