/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.handler;

import com.nxp.s32ds.ext.ide.core.refactoring.ProjectSet;
import com.nxp.s32ds.ext.ide.internal.ui.Messages;
import com.nxp.s32ds.ext.ide.internal.ui.UiActivator;
import com.nxp.s32ds.ext.ide.ui.dialogs.CopyPasteDialog;
import com.nxp.s32ds.ext.ide.ui.refactoring.CopyPasteJob;
import com.nxp.s32ds.ext.ide.ui.util.RefactoringUtils;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.ResourceTransfer;

public class CopyPasteHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional<IResource> resource = CopyPasteHandler.getResourceFromClipboard();
        resource.ifPresent(res -> {
            try {
                ProjectSet projectSet = RefactoringUtils.findProjectSet(res);
                IStatus projectsStatus = RefactoringUtils.validateProjectSet(projectSet);
                if (projectsStatus.isOK()) {
                    CopyPasteHandler.getNewProjectName(event, projectSet).ifPresent(newName -> new CopyPasteJob(projectSet, (String)newName).schedule());
                } else {
                    RcpStatusHandlers.handleStatus((String)"com.nxp.s32ds.ext.rcp.statushandlers.defaultHandler", (IStatus)projectsStatus, (Object)projectsStatus.getMessage());
                }
            }
            catch (Exception e) {
                CopyPasteHandler.logException(e);
            }
        });
        return null;
    }

    private static Optional<IResource> getResourceFromClipboard() {
        Clipboard cb = new Clipboard(Display.getCurrent());
        Object content = cb.getContents((Transfer)ResourceTransfer.getInstance());
        if (content instanceof IResource[]) {
            IResource[] resources = (IResource[])content;
            return Optional.of(resources[0]);
        }
        return Optional.empty();
    }

    private static Optional<String> getNewProjectName(ExecutionEvent event, ProjectSet projectSet) throws ExecutionException {
        CopyPasteDialog dialog = new CopyPasteDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), projectSet);
        if (dialog.open() != 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(dialog.getResult());
    }

    private static void logException(Exception e) {
        try {
            RcpStatusHandlers.handleStatus((String)"com.nxp.s32ds.ext.rcp.statushandlers.defaultHandler", (IStatus)UiActivator.getInstance().createError(Messages.copyPasteError, e), (Object)new Object());
        }
        catch (CoreException ce) {
            UiActivator.getInstance().log(ce.getStatus());
        }
    }
}

