/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.AttributesValuesTable;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.EnableStateSetting;
import com.nxp.swtools.bootimage.settings.ExpressionComponents;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.bootimage.utils.BootUtils;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.SimpleBooleanProperty;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

public abstract class ABaseComponentSetting {
    @Attribute(name="id", required=false)
    private String id;
    @Attribute(name="label", required=false)
    private String label;
    @Element(name="description", required=false)
    @Nullable
    private @Element(name="description", required=false) @Nullable Description description;
    @Attribute(name="value", required=false)
    private String initValue;
    @Attribute(name="options", required=false)
    private String options;
    @Attribute(name="default_memory_value", required=false)
    private String defaultMemValue;
    @ElementList(inline=true, required=false)
    private List<DisableCondition> disableConditionsList;
    @ElementList(inline=true, required=false)
    private List<VisibleCondition> visibleConditionsList;
    @ElementList(inline=true, required=false)
    private List<EnableStateSetting> enableStatesList;
    @ElementList(inline=true, required=false)
    private List<ConfigurableCondition> configurableConditionsList;
    @Element(name="messages", required=false)
    @Nullable
    private @Element(name="messages", required=false) @Nullable MessagesSetting messages;
    @Attribute(name="value_expression", required=false)
    private String valueExpression;
    @Attribute(name="offset_expression", required=false)
    private String offsetExpression;
    private SimpleBooleanProperty currentDisableState = new SimpleBooleanProperty(false);
    protected long valueToWrite;
    @Attribute(name="visible", required=false)
    private boolean visible = true;
    @Element(name="attributes_values", required=false)
    private AttributesValuesTable attributesValuesTable;

    public ABaseComponentSetting(String id, String label, @Nullable Description description, String initValue, String options, @Nullable MessagesSetting messages, long valueToWrite, String valueExpression) {
        this.id = id;
        this.label = label;
        this.description = description;
        this.initValue = initValue;
        this.options = options;
        this.messages = messages;
        this.valueToWrite = valueToWrite;
        this.valueExpression = valueExpression;
        this.offsetExpression = "";
        this.defaultMemValue = "";
        this.disableConditionsList = new ArrayList<DisableCondition>();
        this.visibleConditionsList = new ArrayList<VisibleCondition>();
        this.enableStatesList = new ArrayList<EnableStateSetting>();
        this.configurableConditionsList = new ArrayList<ConfigurableCondition>();
        this.attributesValuesTable = new AttributesValuesTable();
    }

    public ABaseComponentSetting() {
        this("", "", null, "", "", null, 0L, "");
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public @Nullable Description getDescription() {
        return this.description;
    }

    public String getInitValue() {
        return this.initValue;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public List<String> getOptionsList() {
        String[] tempOptionsBuffer;
        ArrayList<String> optionsList = new ArrayList<String>();
        String[] stringArray = tempOptionsBuffer = this.options.split("\\;");
        int n = tempOptionsBuffer.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull String tempStr = stringArray[n2];
            optionsList.add(tempStr);
            ++n2;
        }
        return optionsList;
    }

    public List<DisableCondition> getDisableConditionsList() {
        return this.disableConditionsList;
    }

    public void setDisableConditionsList(List<DisableCondition> disableConditionsList) {
        this.disableConditionsList = disableConditionsList;
    }

    public @Nullable DisableCondition getDisableConditionByFieldId(String conditionFieldId) {
        for (DisableCondition disableCondition : this.disableConditionsList) {
            if (!disableCondition.getFieldId().equalsIgnoreCase(conditionFieldId)) continue;
            return disableCondition;
        }
        return null;
    }

    public List<ConfigurableCondition> getConfigurableConditionsList() {
        return this.configurableConditionsList;
    }

    public void setConfigurableConditionsList(List<ConfigurableCondition> configurableConditionsList) {
        this.configurableConditionsList = configurableConditionsList;
    }

    public @Nullable ConfigurableCondition getconfigurableConditionByFieldId(String conditionFieldId) {
        for (ConfigurableCondition configurableCondition : this.configurableConditionsList) {
            if (!configurableCondition.getFieldId().equalsIgnoreCase(conditionFieldId)) continue;
            return configurableCondition;
        }
        return null;
    }

    public List<EnableStateSetting> getEnableStatesList() {
        return this.enableStatesList;
    }

    public void setEnableStatesList(List<EnableStateSetting> enableStatesList) {
        this.enableStatesList = enableStatesList;
    }

    public @Nullable EnableStateSetting getEnableStateByCondField(String condFieldId) {
        for (EnableStateSetting enableState : this.enableStatesList) {
            if (!enableState.getConditionField().equals(condFieldId)) continue;
            return enableState;
        }
        return null;
    }

    public List<VisibleCondition> getVisibleConditionsList() {
        return this.visibleConditionsList;
    }

    public void setVisibleConditionsList(List<VisibleCondition> visibleConditionsList) {
        this.visibleConditionsList = visibleConditionsList;
    }

    public @Nullable VisibleCondition getVisibleConditionByFieldId(String fieldId) {
        for (VisibleCondition visibleCondition : this.visibleConditionsList) {
            if (!visibleCondition.getFieldId().equals(fieldId)) continue;
            return visibleCondition;
        }
        return null;
    }

    public SimpleBooleanProperty getCurrentDisableState() {
        return this.currentDisableState;
    }

    public void setCurrentDisableState(boolean currentDisableState) {
        this.currentDisableState.set(currentDisableState);
    }

    public @Nullable MessagesSetting getMessages() {
        return this.messages;
    }

    public long getValueToWrite() {
        return this.valueToWrite;
    }

    public void setValueToWrite(long valueToWrite) {
        this.valueToWrite = valueToWrite;
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean hasOffsetExpression() {
        return !this.getOffsetExpression().equals("");
    }

    public String getOffsetExpression() {
        return this.offsetExpression;
    }

    public long getOffsetExpressionResult(ExpressionComponents offsetExpressionComponents) {
        return BootUtils.resolveComponentExpression(offsetExpressionComponents, this.getOffsetExpression());
    }

    public boolean hasDefaultMemoryValue() {
        return !this.defaultMemValue.isEmpty();
    }

    public long getDefaultMemoryValue() {
        long value = 0L;
        if (NumberFormatValidator.isValidXmlHexFormat((String)this.defaultMemValue)) {
            value = NumberFormatValidator.getDecimalLongFromXmlHex((String)this.defaultMemValue);
        } else if (NumberFormatValidator.isValidDecimal((String)this.defaultMemValue)) {
            value = NumberFormatValidator.getLongFromStringDecimal((String)this.defaultMemValue);
        } else if (NumberFormatValidator.isValidXmlBinaryFormat((String)this.defaultMemValue)) {
            value = NumberFormatValidator.getDecimalIntegerFromXmlBinary((String)this.defaultMemValue);
        }
        return value;
    }

    public AttributesValuesTable getAttributesValuesTable() {
        return this.attributesValuesTable;
    }

    @Root(name="must_configure_when", strict=false)
    public static class ConfigurableCondition
    extends ABaseComponentSetting {
        @Attribute(name="field_id")
        private String fieldId;
        @Attribute(name="field_value")
        private String fieldValue;

        public ConfigurableCondition(String id, String label, @Nullable Description description, String fieldId, String fieldValue, String options, @Nullable MessagesSetting messages) {
            super(id, label, description, "", options, messages, -1L, "");
            this.fieldId = fieldId;
            this.fieldValue = fieldValue;
        }

        public ConfigurableCondition() {
            this.fieldId = "";
            this.fieldValue = "";
        }

        public String getFieldId() {
            return this.fieldId;
        }

        public List<String> getFieldValues() {
            String[] tempValuesBuffer;
            ArrayList<String> values = new ArrayList<String>();
            String[] stringArray = tempValuesBuffer = this.fieldValue.split("\\|");
            int n = tempValuesBuffer.length;
            int n2 = 0;
            while (n2 < n) {
                String tempStr = stringArray[n2];
                if (!tempStr.equals("")) {
                    values.add(tempStr);
                }
                ++n2;
            }
            return values;
        }
    }

    @Root(name="disabled_when", strict=false)
    public static class DisableCondition
    extends ABaseComponentSetting {
        @Attribute(name="field_id")
        private String fieldId;
        @Attribute(name="field_value")
        private String fieldValue;
        @Attribute(name="value_to_write", required=false)
        @Nullable
        private @Attribute(name="value_to_write", required=false) @Nullable String componentValue;

        public DisableCondition(String id, String label, @Nullable Description description, String fieldId, String fieldValue, @Nullable String componentValue, String options, @Nullable MessagesSetting messages) {
            super(id, label, description, "", options, messages, -1L, "");
            this.fieldId = fieldId;
            this.fieldValue = fieldValue;
            this.componentValue = componentValue;
        }

        public DisableCondition() {
            this.fieldId = "";
            this.fieldValue = "";
            this.componentValue = null;
        }

        public String getFieldId() {
            return this.fieldId;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }

        public @Nullable String getComponentValue() {
            return this.componentValue;
        }
    }

    @Root(name="visible", strict=false)
    public static class VisibleCondition
    extends ABaseComponentSetting {
        @Attribute(name="field_id")
        private String fieldId;
        @Attribute(name="field_value")
        private String fieldValue;

        public VisibleCondition(String id, String label, @Nullable Description description, String value, String fieldId, String fieldValue, String options, @Nullable MessagesSetting messages) {
            super(id, label, description, value, options, messages, -1L, "");
            this.fieldId = fieldId;
            this.fieldValue = fieldValue;
        }

        public VisibleCondition() {
            super("", "", null, "true", "", null, -1L, "");
            this.fieldId = "";
            this.fieldValue = "";
        }

        public Boolean getValue() {
            return "true".equalsIgnoreCase(this.getInitValue()) ? Boolean.TRUE : Boolean.FALSE;
        }

        public String getFieldId() {
            return this.fieldId;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }
    }
}

