/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseCustomComponentSetting;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.EnableStateSetting;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="enum", strict=false)
public class EnumSetting
extends ABaseCustomComponentSetting
implements IProblemSource {
    @ElementList(inline=true)
    private List<ItemSetting> items = new ArrayList<ItemSetting>();
    private String currentSelection;

    public EnumSetting(String id, String label, @Nullable Description description, String offset, String size, String initValue, long valueToWrite, String options, @Nullable MessagesSetting messages) {
        super(id, label, description, offset, size, initValue, valueToWrite, options, messages, null, "");
        this.currentSelection = initValue;
    }

    public EnumSetting() {
        this.currentSelection = "";
    }

    public List<ItemSetting> getItems() {
        ArrayList<ItemSetting> availableItems = new ArrayList<ItemSetting>();
        boolean itemState = true;
        for (ItemSetting item : this.items) {
            for (EnableStateSetting enableState : item.getEnableStatesList()) {
                if (enableState.getConditionExpression() == null) continue;
                itemState &= enableState.getStateFromConditionExpression();
            }
            if (!itemState) continue;
            availableItems.add(item);
        }
        return availableItems;
    }

    public void setItems(List<ItemSetting> items) {
        this.items = items;
    }

    public @Nullable ItemSetting getItemById(String id) {
        for (ItemSetting item : this.items) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        return null;
    }

    public @Nullable ItemSetting getItemByLabel(String label) {
        for (ItemSetting item : this.items) {
            if (!item.getLabel().equals(label)) continue;
            return item;
        }
        return null;
    }

    public @Nullable ItemSetting getItemByValue(long value) {
        for (ItemSetting item : this.items) {
            if (item.getItemValue() != value) continue;
            return item;
        }
        return null;
    }

    public String getCurrentSelection() {
        return this.currentSelection;
    }

    public void setCurrentSelection(String currentSelection) {
        this.currentSelection = currentSelection;
    }

    public void updateValueToWrite(String selectedItem) {
        for (ItemSetting item : this.items) {
            if (!item.getLabel().equals(selectedItem)) continue;
            this.valueToWrite = item.getItemValue();
        }
    }

    @Root(name="item", strict=false)
    public static class ItemSetting
    extends ABaseCustomComponentSetting {
        @Attribute(name="last_item", required=false)
        protected boolean lastItem;
        @Attribute(name="blob_offset", required=false)
        private String blobOffset;

        public ItemSetting(String id, String label, Description description, String offset, String size, String initValue, String blobOffset, long valueToWrite, String options, @Nullable MessagesSetting messages, boolean lastItem) {
            super(id, label, description, offset, size, initValue, valueToWrite, options, messages, null, "");
            this.blobOffset = blobOffset;
            this.lastItem = lastItem;
        }

        public ItemSetting() {
            this.blobOffset = "";
            this.lastItem = false;
        }

        public long getItemValue() {
            long itemValue = 0L;
            if (NumberFormatValidator.isValidXmlHexFormat((String)this.getInitValue())) {
                itemValue = NumberFormatValidator.getDecimalLongFromXmlHex((String)this.getInitValue());
            } else if (NumberFormatValidator.isValidDecimal((String)this.getInitValue())) {
                itemValue = NumberFormatValidator.getLongFromStringDecimal((String)this.getInitValue());
            } else if (NumberFormatValidator.isValidXmlBinaryFormat((String)this.getInitValue())) {
                itemValue = NumberFormatValidator.getDecimalIntegerFromXmlBinary((String)this.getInitValue());
            }
            return itemValue;
        }

        public boolean canAddMoreItems() {
            return !this.lastItem;
        }

        public String getBlobOffset() {
            return this.blobOffset;
        }

        public long getBlobOffsetValue() {
            long value = 0L;
            if (NumberFormatValidator.isValidXmlHexFormat((String)this.getBlobOffset())) {
                value = NumberFormatValidator.getDecimalLongFromXmlHex((String)this.getBlobOffset());
            } else if (NumberFormatValidator.isValidDecimal((String)this.getBlobOffset())) {
                value = NumberFormatValidator.getLongFromStringDecimal((String)this.getBlobOffset());
            } else if (NumberFormatValidator.isValidXmlBinaryFormat((String)this.getBlobOffset())) {
                value = NumberFormatValidator.getDecimalIntegerFromXmlBinary((String)this.getBlobOffset());
            }
            return value;
        }
    }
}

